
/* **************************************************************************

  $Archive: /njcl/src/com/novell/utility/naming/spi/ContextFactory.java $
  $Revision: 1 $
  $Modtime: 4/22/98 8:42a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.spi;


import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

import com.novell.utility.naming.Environment;


/** @internal
 *
 */
public interface ContextFactory extends ObjectFactory
{
   /**
    * Context validity unknown
    */
   public Context getContextInstance (
         String contextName,
         Environment environment)
      throws NamingException;

   /**
    * Context is valid
    */
   public Context getContextInstance (
         String contextName,
         Object classInfo,
         Environment environment)
      throws NamingException;

   /**
    * A Context object supplies information to produce another context.
    */
   public Context getContextInstance (
         Object context)
      throws NamingException;

   /**
    * Return the class name using the classId object.
    */
   public String getClassName (
         Object classId)
      throws NamingException;

} /* ContextFactory */


