/* **************************************************************************
  $Archive: /njcl_sample/Authenticator/GetIdentities.java $
  $Revision: 1 $
  $Modtime: 8/11/98 5:23p $

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyIdentityScope;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;

/**
 * Sample which demonstrates how to use <code>Authenticator.getIdentities</code>.
 */
public class GetIdentities
{
   static public void main(String args[])
   {
      try
      {
         Identity identities[];

         IdentityScope scope = null;
         if(args.length == 0)
            scope = null;
         else if(args[0].equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME))
            scope = buildNdsIdentityScope(null,0,args);
         else if(args[0].equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME))
            scope = buildBinderyIdentityScope(null,0,args);
         else
         {
            System.out.println("Usage:  GetIdentities [[NDS]-or-[BINDERY]]");
            System.out.println("E.g.:   GetIdentities");
            System.out.println("E.g.:   GetIdentities [NDS]");
            System.out.println("E.g.:   GetIdentities [BINDERY]");
            System.exit(-1);
         }

         if(scope == null)
            identities = Authenticator.getIdentities();
         else
            identities = Authenticator.getIdentities(scope);

         if(identities != null)
         {
            System.out.println("Found "+identities.length+" identities:");
            for(int i = 0; i < identities.length; i++)
               System.out.println(printIdentity(identities[i]));
         }
         else
         {
            System.out.println("Found no identities.");            
         }
      }
      catch(java.lang.Throwable e)
      {
         if (e instanceof java.lang.ExceptionInInitializerError)
            ((java.lang.ExceptionInInitializerError)e).getException().printStackTrace();
         e.printStackTrace();
      }
      finally
      {
         // Must exit (see bug 4072987 at
         // http://developer.javasoft.com/developer/bugParade)
         System.exit(0);
      }
   }
   
   /*
    * Constructs an identity with it's appropriate identity scopes.
    * See documentation for details.
    */
   static IdentityScope buildNdsIdentityScope(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new NdsIdentityScope();

      if(!(offset < args.length-1))
         return new NdsIdentityScope(args[offset],scope);

      return buildNdsIdentityScope(new NdsIdentityScope(args[offset],scope), ++offset, args);
   }

   /*
    * Constructs an identity with it's appropriate identity scopes.
    * See documentation for details.
    */
   static IdentityScope buildBinderyIdentityScope(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new BinderyIdentityScope();

      if(!(offset < args.length-1))
         return new BinderyIdentityScope(args[offset],scope);

      return buildBinderyIdentityScope(new BinderyIdentityScope(args[offset],scope), ++offset, args);
   }

   static String printIdentity(Identity identity)
   {
      String name = identity.getName();
      
      IdentityScope scope = identity.getScope();
      if(scope != null)
         name += "."+printIdentity(scope);

      return name;
   }
}