/***************************************************************************
 %name: FileList.java
 %version: 
 %date_modified: 
 %dependencies: TextualStatic.java
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NameClassPair;

import com.novell.utility.naming.Environment;

import com.novell.service.file.nw.NetwareVolume;
import com.novell.service.file.nw.NetwareDirectory;
import com.novell.service.file.nw.NetwareFile;

/**
 * Example of listing the subordinate items in a Directory Context
 *
 * <p>This program demonstrates the code that can be used to display the
 * names of objects bound to a given Directory or Volume Context.
 *
 *<p>Files are listed as named.  Directory names are placed inside of square
 * brackets - "[name]".  Explicitly bound names are placed inside of curly
 * braces - "{name}".
 */

public class FileList
{
   /**
    * FileList example
    *
    * <p>This example lists the names of objects bound to a Directory
    * DirContext in the NetWare file system name space.
    * </p>
    *
    * @param   args[]
    * where    args[0]  url (url to list)
    *                   The name of a Context from the File system
    *                   initial context.  For example:
    *                   "my_server/my_volume/my_dir"
    */

    public static void main(String args[])
    {
      // see if user has given the URL on the command line
      if (args.length < 1)
      {
         help();
      }

      String url = args[0];
      
      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.FS_INITIAL_CONTEXT_FACTORY);
      systemProps.put(Context.PROVIDER_URL, url);

      try
      {
         // Look up the object named by the command line parameter.
         Object obj = new InitialContext(systemProps).lookup("");

         System.out.println("\nListing bindings for directory: " + url + "\n");

         // Get an NamingEnumeration of NameClassPairs
         NamingEnumeration ncEnum = ((Context)obj).list("");

         // Get the bindings bound to this Context.
         NamingEnumeration bindingEnum = ((Context)obj).listBindings("");

         while (ncEnum.hasMore())
         {
            /*
               We retrieved the bindings so we can determine the type of the
               objects bound to the context.  We will look for well known
               interfaces to determine the type of the bindings objects
            */
            NameClassPair ncPair = (NameClassPair)ncEnum.next();
            Binding binding = (Binding)bindingEnum.next();

            obj = binding.getObject();

            // Retrieve the interfaces this object implements
            Class[] interfaces = obj.getClass().getInterfaces();
            boolean volume = false;
            boolean directory = false;
            boolean file = false;
            for (int i=0; i < interfaces.length; i++)
            {
               /*
                   if it's a volume place in <>
                   since a volume is a directory, this check must be first
               */
               if (interfaces[i].getName().equals("com.novell.service.file.nw.NetwareVolume"))
               {
                  volume = true;
                  break;
               }

               /*
                   if it's a directory place in []
                   since a directory is also a file, this check must be next
               */
               if (interfaces[i].getName().equals("com.novell.service.file.nw.NetwareDirectory"))
               {
                  directory = true;
                  break;
               }

               // if it's a file don't enclose it
               if (interfaces[i].getName().equals("com.novell.service.file.nw.NetwareFile"))
               {
                  file = true;
                  break;
               }
            }
            if (volume)
            {
               System.out.println("<" + ncPair.getName());
            }
            else
            if (directory)
            {
               System.out.println("[" + ncPair.getName());
            }
            else
            if (file)
            {
               System.out.println(ncPair.getName());
            }
            else
            {
               // must be an explicit binding
               System.out.println("{" + ncPair.getName());
            }
         }
      }
      catch (javax.naming.NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }
      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println("\tjava FileList <url>\n");
      System.out.println(
         "\t\turl = name of the File System Context to list binding names on");
      System.out.println("\t\t       my_server/my_volume/my_dir");
      System.out.println("");
      System.out.println("results are:\n");
      System.out.println("file");
      System.out.println("[directory]");
      System.out.println("<volume>");
      System.out.println("{explicit_binding}");
      System.exit(-1);
   }
}



