/****************************************************************************
  $Workfile: NSIAttributeFrame.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

/**
 * This class is responsible for displaying a list of attributes for a
 * given DirContext.
 */

public class NSIAttributeFrame extends Frame
                               implements WindowListener,
                               ActionListener
{
   public static final int width = 420;
   public static final int height = 400;

   DirContext currDirCtx;
   List attrList;         // component for showing attr names
   Vector attrVector;         // parallel vector of names only

   /**
    * Constructs a frame for displaying the attributes of a DirContext.
    *
    * @param     dirCtx           (in) Valid DirContext
    */
   public NSIAttributeFrame (
         DirContext dirCtx)
   {
      super ("Attributes");

      currDirCtx = dirCtx;

      attrList = new List ();
      attrVector = new Vector ();
      add ("Center", attrList);
      updateList ();

      // Setup the Listeners
      addWindowListener (this);
      attrList.addActionListener (this);
      pack ();
   }

   /**
    * This is the action handler for the main window (frame).
    *
    * @param     evt             (in) The event
    */
   public void actionPerformed (
      ActionEvent evt)
   {
      Object target = evt.getSource();

      if (target == attrList)
      {  // We could do something extra here, but we're not right now
      }
   } // action ()

   /**
    * Implement WindowListener functions.  We really only want the
    * windowClosing one.
    */

   public void windowClosed (
      WindowEvent event)
   {
   }

   public void windowDeiconified (
      WindowEvent event)
   {
   }

   public void windowIconified (
      WindowEvent event)
   {
   }

   public void windowActivated (
      WindowEvent event)
   {
   }

   public void windowDeactivated (
      WindowEvent event)
   {
   }

   public void windowOpened (
      WindowEvent event)
   {
   }

   public void windowClosing (
      WindowEvent event)
   {
      dispose ();
   }

   void updateList ()
   {
      this.setCursor (Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));    // We're probably going to be a while

      try
      {
         Attributes attrSet;
         NamingEnumeration attrEnum = null;
         Attribute attr;
         SortableString sortStr;
         int attrCount;

         attrSet = currDirCtx.getAttributes ("");
         if (null != attrSet)
            attrEnum = attrSet.getAll ();

         if (null == attrEnum)
            attrCount = 0;
         else
            attrCount = attrSet.size ();

         if (0 == attrCount)
         {
            attrVector.addElement (new SortableString ("No Attributes"));
            attrCount++;   // We just added one (a dummy)
         }
         else
         {
            while (attrEnum.hasMoreElements ())
            {
               attr = (Attribute) attrEnum.next ();
               sortStr = new SortableString (attr.toString ());
               attrVector.addElement (sortStr);
            }
            QuickSort.sort (attrVector, 0, attrCount - 1);
         }
         for (int i = 0; i < attrCount; i++)
         {
            sortStr = (SortableString) attrVector.elementAt (i);
            attrList.addItem (sortStr.toString ());
         }
      }
      catch (NamingException e)
      {
         System.out.println ("Unable to list attributes");
         System.out.println ("Unexpected naming exception " + e);
         e.printStackTrace ();
      }
      this.setCursor (Cursor.getDefaultCursor());    // Finally, restore the cursor
   }

} // class NSIAttributeFrame
