/****************************************************************************
  $Workfile: NSIMessageBox.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

import java.awt.*;
import java.awt.event.*;

class NSIMessageBox extends Frame
                    implements WindowListener,
                    ActionListener
{
   Button okButton = new Button ("OK");

   /**
    * Constructs and shows a dialog box with a title and OK button.
    */
   NSIMessageBox
   (
      String title
   )
   {
      this (title, (String) null);
   } // NSIMessageBox ()

   /**
    * Constructs and shows a dialog box with a title, message and OK button.
    */
   NSIMessageBox
   (
      String title,
      String message
   )
   {
      super (title);
      GridLayout gl = new GridLayout (2, 1);
      setLayout (gl);
      if (null != message)
      {
         add ("North", new TextField (message));
         add ("South", okButton);
      }
      else
         add ("Center", okButton);

      // Setup the Listeners
      addWindowListener (this);
      okButton.addActionListener (this);

      pack ();
      show ();
   } // NSIMessageBox ()

   /**
    * This is the action handler for the message box window (dialog).
    *
    * @param     evt             (in) The event
    */
   public void actionPerformed (
      ActionEvent evt)
   {
      Object target = evt.getSource();

      if (target == okButton)
      {
         dispose ();
      }
   } // action ()

   /**
    * Implement WindowListener functions.  We really only want the
    * windowClosing one.
    */

   public void windowClosed (
      WindowEvent event)
   {
   }

   public void windowDeiconified (
      WindowEvent event)
   {
   }

   public void windowIconified (
      WindowEvent event)
   {
   }

   public void windowActivated (
      WindowEvent event)
   {
   }

   public void windowDeactivated (
      WindowEvent event)
   {
   }

   public void windowOpened (
      WindowEvent event)
   {
   }

   public void windowClosing (
      WindowEvent event)
   {
      dispose ();
   }

} // class NSIMessageBox
