/***************************************************************************
 %name:
 %version:
 %date_modified:
 %dependencies:

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import com.novell.service.session.*;
import com.novell.service.session.nds.NDS;
import com.novell.service.session.bindery.Bindery;

/**
 * Creates a session and searches for all current sessions.
 */
public class CreateAndListSessions
{
   public static void main(String args[])
   {
      try
      {
         if(args.length != 2)
         {
            System.out.println("Usage: java CreateAndListSessions <NDS | BINDERY | DEFAULT> <domaninName>");
            System.out.println("Examples: java CreateAndListSessions NDS ServerName");
            System.out.println("Examples: java CreateAndListSessions NDS TreeName");
            System.out.println("Examples: java CreateAndListSessions BINDERY ServerName");
            System.out.println("Examples: java CreateAndListSessions DEFAULT ServerName");
            System.exit(0);
         }
         String provider = args[0];
         String domainName = args[1];
         
         SessionEnv env = new SessionEnv();

         // Define initial sessions and the order which they will be accessed
         env.put(SessionEnv.INITIAL_SESSION_FACTORY,
            "com.novell.service.session.nds.NDSInitialSessionFactory:" +
            "com.novell.service.session.bindery.BinderyInitialSessionFactory");

         // Get the session manager
         SessionManager sm = SessionManagerFactory.getSessionManager(env);
         
         if(provider.equalsIgnoreCase("NDS"))
            sm.getSession(NDS.INITIAL_SESSION).getSession(domainName);
         else if(provider.equalsIgnoreCase("BINDERY"))
            sm.getSession(Bindery.INITIAL_SESSION).getSession(domainName);
         else if(provider.equalsIgnoreCase("DEFAULT"))
            sm.getSession(domainName);
         else
         {
            System.out.println("Invalid provider specified");
            System.exit(1);
         }
         
         System.out.println("Listing Trees:  ");
         doListing(sm, "NDS", "TREE");
         
         System.out.println("Listing NDS Connected Servers:  ");
         doListing(sm, "NDS", "SERVER");
         
         System.out.println("Listing Bindery Connected Servers:  ");
         doListing(sm, "BINDERY", "SERVER");
      }
      catch (Exception e)
      {
         com.novell.service.session.util.Debug.dumpExceptionAlways(e);
      }
      System.out.println("* denotes Authenticated Connection");
   }
   
   static void doListing(Session sm, String provider, String session_type)
   throws SessionException
   {
      // Look for existing sessions
      SessionAttr a1 = new SessionAttr(Session.PROVIDER_NAME_ATTR_ID, provider);
      SessionAttr a2 = new SessionAttr(Session.SESSION_TYPE_ATTR_ID, session_type);
      
      SessionAttrs as = new SessionAttrs();
      as.add(a1);
      as.add(a2);
      SessionEnumerator enum = sm.search(as);
      while (enum.hasMoreElements())
      {  
         Session found = enum.next();
         
         if (found.isAuthenticated())
            System.out.print(" * ");
         else
            System.out.print("   ");
                
         System.out.println(found.getDomainName());
      }
      System.out.println();
   }
}
