/***************************************************************************
 %name: LoginSession.java
 %version:1.0 
 %date_modified:08/14/98 
 %dependencies: none

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.novell.utility.naming.Environment;
import com.novell.service.session.Session;
import com.novell.service.session.Authenticatable;
import com.novell.java.security.Identity;
import com.novell.java.security.Authenticator;

/**
 * Finds a context and logs in a session associated with that
 * context.
 */
public class LoginSession
{
   /**
    * Used for testing this class.
    */
   public static void main(String args[])
   {
      try
      {
         if (args.length < 2)
            help();
            
         String url = args[0];
         String userName = args[1];
         /**
          * Create a new Hashtable object and get a context.
          */
         Hashtable hash = new Hashtable();
         hash.put(
               Context.INITIAL_CONTEXT_FACTORY,
               Environment.NW_INITIAL_CONTEXT_FACTORY);
         hash.put(Context.PROVIDER_URL, url);
         
         InitialContext initCtx = new InitialContext(hash);
         hash = initCtx.getEnvironment ();
         /**
          * Get the context's session.
          */
         Session sess = (Session) hash.get (Environment.SESSION_OBJECT);
         if (null == sess)
            throw new Exception ("No session found on the context: " + url);
         /**
          * Create an Identity from the context's session.
          */
         Identity id = ((Authenticatable) sess).createIdentity (userName);
         /**
          * Use the Authenticator to log in the Identity.
          */
         Authenticator.login (id);
      }
      catch (Exception e)
      {
         System.out.println("Exception occured: " + e.toString ());
         e.printStackTrace();       // show details in case debugging is on
      }
   }
   
   public static void help()
   {
      System.out.println("LoginSession -- logs in a session associated with a context");
      System.out.println("usage: java LoginSession <provider_url> <username>");
      System.exit(-1);
   }
}

