/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/io/InputStreamNotSupportedException.java $
  $Revision: 5 $
  $Modtime: 1/18/00 9:25a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.io;

import java.io.ObjectStreamException;

/**
 * Signals that input stream access is not available.
 * 
 * <p>The DataAccessable interface provides support for Input/Output
 * streams and random access to the data of the DataAccessable object.
 * Some devices do not support input stream access but might support
 * the output stream or random access. This exception is thrown if an
 * input stream open is attempted to a device that is not supported.</p>
 *
 * @see NInputStream
 */

public class InputStreamNotSupportedException extends ObjectStreamException
{
   /**
    * Constructs an InputStreamNotSupportedException object with no
    * detail message. 
    */
    
   public InputStreamNotSupportedException()
   {
   }


   /**
    * Constructs an InputStreamNotSupportedException object with the
    * specified detail message. 
    *
    * @param s The detail message.
    */
    
   public InputStreamNotSupportedException(String s)
   {
      super(s);
   }
}   