/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/io/RandomAccessNotSupportedException.java $
  $Revision: 4 $
  $Modtime: 1/18/00 9:26a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.io;

import java.io.IOException;

/**
 * Signals that random access is not available.
 * 
 * <p>The DataAccessable interface provides support for Input/Output
 * streams and random access to the data of the DataAccessable object.
 * Some devices do not support random access but might support the input
 * or output stream. This exception is thrown if a random access open is
 * attempted to a device that is not supported.</p>
 *
 * @see RandomAccess
 */
 
public class RandomAccessNotSupportedException extends IOException
{
   /**
    * Constructs a RandomAccessNotSupportedException object with no
    * detail message. 
    */
    
   public RandomAccessNotSupportedException()
   {
   }


   /**
    * Constructs a RandomAccessNotSupportedException object with the
    * specified detail message. 
    *
    * @param s The detail message.
    */
    
   public RandomAccessNotSupportedException(String s)
   {
      super(s);
   }
}   