/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/NetwareVolume.java $
  $Revision: 9 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import com.novell.service.jncp.NSIException;

/** 
 * Provides an interface for getting the volume object attribute values. 
 *
 * <p>The associated volume object attribute values are
 * <ul><li>Trustee Path Enumeration
 * <li>Volume Information
 * <li>Volume Restriction
 * <li>Volume Restriction Enumeration
 * <li>Volume Utilization</ul></p>
 */
public interface NetwareVolume extends NetwareDirectory
{
   /**
    * Returns the VolumeInformation object associated with this volume.
    * 
    * @return The VolumeInformation object.
    *
    * @exception NSIException when there is an error in getting the
    *                         VolumeInformation object.
    */
   public VolumeInformation getVolumeInformation()
      throws NSIException;

   /**
    * Returns the VolumeUtilization object associated with this volume.
    * 
    * @return The VolumeUtilization object.
    *
    * @exception NSIException when there is an error in getting the
    *                         VolumeUtilization object.
    */
   public VolumeUtilization getVolumeUtilization()
      throws NSIException;

   /**
    * Returns the VolumeRestrictionEnumerator object associated with
    * this volume.
    * 
    * @return The VolumeRestrictionEnumerator object.
    *
    * @exception NSIException when there is an error in getting the
    *                         VolumeRestrictionEnumerator object.
    */
   public VolumeRestrictionEnumerator getVolumeRestrictionEnumerator()
      throws NSIException;

   /**
    * Modifies the back end VolumeRestriction object associated with 
    * this volume.
    *
    * @param  vr     The VolumeRestriction modify value.
    * @param  mod_op The modification to perform if the attribute is
    *                part of the set; valid values are
    *                DirContext.ADD_ATTRIBUTE,
    *                DirContext.REMOVE_ATTRIBUTE, and
    *                DirContext.REPLACE_ATTRIBUTE.
    *
    * @exception NSIException when there is an error in setting the
    *                         VolumeRestriction object.
    */
   public void setVolumeRestriction(
      VolumeRestriction vr,
      int mod_op)
      throws NSIException;

   /**
    * Returns the TrusteePathEnumerator object associated with this volume.
    * 
    * @return  The TrusteePathEnumerator object.
    *
    * @exception NSIException when there is an error in getting the
    *                         TrusteePathEnumerator object.
    *
    * @exception NSIException when there is an error in getting the
    *                         TrusteePathEnumerator object.
    */
   public TrusteePathEnumerator getTrusteePathEnumerator()
      throws NSIException;
}

