/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncp/NSIExceptionBuilder.java $
  $Revision: 6 $
  $Modtime: 3/08/00 7:14p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

/* @(#)NSIExceptionBuilder.java        1.00  96/11/11    NSI Development Team
 *
 */

package com.novell.service.jncp;


/**@internal
 * NSIExceptionBuilder contains methods for generating NSIException
 * subclasses.<p>
 *
 * @version     1.00, 11 Nov 1996
 * @author      NSI Development Team
 */

public class NSIExceptionBuilder
{
   private static boolean isNetWare = false;
   static
   {
      try
      {
         String osName = System.getProperty("os.name", "");

         if (osName.startsWith("NetWare"))
            isNetWare = true;
      }
      catch (Exception e)
      {
         e.printStackTrace ();

         System.exit (1);
      }
   }
   /**
    * Returns exception based on origin or ccode.
    */
   static public NSIException build(int ccode)
   {
      NSIException e;
      String s = "ccode = " + ccode +
         " (0x" + Integer.toHexString(ccode) + ")";
      if ((ccode & 0xff00) == 0x8800)
      {
         // Client error
         e = new ClientException(s);
      }
      else if ((ccode & 0xff00) == 0x8900)
      {
         if (isNetWare && ccode > 0x8900 && ccode < 0x8918)
         {
            // Server requester error
            e = new ServerRequesterException(s);
         }
         else
         {
            // Server error
            e = new ServerException(s);
         }
      }
      else if (ccode < 0)
      {
         // NDS error
         e = new NDSException(s);
      }
      else
      {
         // Unknown error (OS?)
         e = new NSIException(s);
      }
      e.setCCode(ccode);
      return e;
   }

   /**
    * Returns exception based on root exception.
    */
   static public NSIException build(Throwable rootCause)
   {
      NSIException e;
      String s = "Caught exception";
      if (rootCause instanceof ClientException)
      {
         // Client error
         e = new ClientException(s);
      }
      else if (rootCause instanceof ServerRequesterException)
      {
         // Server error
         e = new ServerRequesterException(s);
      }
      else if (rootCause instanceof ServerException)
      {
         // Server error
         e = new ServerException(s);
      }
      else if (rootCause instanceof NDSException)
      {
         // NDS error
         e = new NDSException(s);
      }
      else
      {
         // Unknown error (OS?)
         e = new NSIException(s);
      }
      e.setRootCause(rootCause);
      return e;
   }

   /**
    * Returns exception based on ccode and root cause.
    */
   static public NSIException build(int ccode, Throwable rootCause)
   {
      NSIException e = build(ccode);
      e.setRootCause(rootCause);
      return e;
   }
}


