/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncp/ServerErrors.java $
  $Revision: 5 $
  $Modtime: 1/28/00 11:07a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

/* @(#)ServerErrors.java        1.00  96/11/11    NSI Development Team
 *
 */

package com.novell.service.jncp;

/**
 * Static list of known errors returned from native server calls<p>
 *
 * @version     1.00, 11 Nov 1996
 * @author      NSI Development Team
 */

public class ServerErrors
{
   /**
    * <p> (NWE_INSUFFICIENT_SPACE                  = 0x8901)
    * </p>
    */
   public static final int NWE_INSUFFICIENT_SPACE                  = 0x8901;

   /**
    * <p> (NWE_INVALID_CONNECTION                  = 0x890a)
    * </p>
    */
   public static final int NWE_INVALID_CONNECTION                  = 0x890a;

   /**
    * <p> (NWE_NO_MORE_ENTRY                       = 0x8914)
    * </p>
    */
   public static final int NWE_NO_MORE_ENTRIES                     = 0x8914;

   /**
    * <p> (NWE_BUFFER_TOO_SMALL                    = 0x8977)
    * </p>
    */
   public static final int NWE_BUFFER_TOO_SMALL                    = 0x8977;

   /**
    * <p> (NWE_VOL_FLAG_NOT_SET                    = 0x8978)
    * </p>
    */
   public static final int NWE_VOL_FLAG_NOT_SET                    = 0x8978;

   /**
    * <p> (NWE_NO_ITEMS_FOUND                      = 0x8979)
    * </p>
    */
   public static final int NWE_NO_ITEMS_FOUND                      = 0x8979;

   /**
    * <p> (NWE_CONN_ALREADY_TEMP                   = 0x897a)
    * </p>
    */
   public static final int NWE_CONN_ALREADY_TEMP                   = 0x897a;

   /**
    * <p> (NWE_CONN_ALREADY_LOGGED_IN              = 0x897b)
    * </p>
    */
   public static final int NWE_CONN_ALREADY_LOGGED_IN              = 0x897b;

   /**
    * <p> (NWE_CONN_NOT_AUTHENTICATED              = 0x897c)
    * </p>
    */
   public static final int NWE_CONN_NOT_AUTHENTICATED              = 0x897c;

   /**
    * <p> (NWE_CONN_NOT_LOGGED_IN                  = 0x897d)
    * </p>
    */
   public static final int NWE_CONN_NOT_LOGGED_IN                  = 0x897d;

   /**
    * <p> (NWE_NCP_BOUNDARY_CHECK_FAILED           = 0x897e)
    * </p>
    */
   public static final int NWE_NCP_BOUNDARY_CHECK_FAILED           = 0x897e;

   /**
    * <p> (NWE_LOCK_WAITING                        = 0x897f)
    * </p>
    */
   public static final int NWE_LOCK_WAITING                        = 0x897f;

   /**
    * <p> (NWE_LOCK_FAIL                           = 0x8980)
    * </p>
    */
   public static final int NWE_LOCK_FAIL                           = 0x8980;

   /**
    * <p> (NWE_FILE_IN_USE                         = 0x8980)
    * </p>
    */
   public static final int NWE_FILE_IN_USE                         = 0x8980;

   /**
    * <p> (NWE_FILE_NO_HANDLES                     = 0x8981)
    * </p>
    */
   public static final int NWE_FILE_NO_HANDLES                     = 0x8981;

   /**
    * <p> (NWE_FILE_NO_OPEN_PRIV                   = 0x8982)
    * </p>
    */
   public static final int NWE_FILE_NO_OPEN_PRIV                   = 0x8982;

   /**
    * <p> (NWE_DISK_IO_ERROR                       = 0x8983)
    * </p>
    */
   public static final int NWE_DISK_IO_ERROR                       = 0x8983;

   /**
    * <p> (NWE_FILE_NO_CREATE_PRIV                 = 0x8984)
    * </p>
    */
   public static final int NWE_FILE_NO_CREATE_PRIV                 = 0x8984;

   /**
    * <p> (NWE_FILE_NO_CREATE_DEL_PRIV             = 0x8985)
    * </p>
    */
   public static final int NWE_FILE_NO_CREATE_DEL_PRIV             = 0x8985;

   /**
    * <p> (NWE_FILE_EXISTS_READ_ONLY               = 0x8986)
    * </p>
    */
   public static final int NWE_FILE_EXISTS_READ_ONLY               = 0x8986;

   /**
    * <p> (NWE_DIR_TARGET_INVALID                  = 0x8986)
    * </p>
    */
   public static final int NWE_DIR_TARGET_INVALID                  = 0x8986;

   /**
    * <p> (NWE_FILE_WILD_CARDS_IN_NAME             = 0x8987)
    * </p>
    */
   public static final int NWE_FILE_WILD_CARDS_IN_NAME             = 0x8987;

   /**
    * <p> (NWE_FILE_INVALID_HANDLE                 = 0x8988)
    * </p>
    */
   public static final int NWE_FILE_INVALID_HANDLE                 = 0x8988;

   /**
    * <p> (NWE_FILE_NO_SRCH_PRIV                   = 0x8989)
    * </p>
    */
   public static final int NWE_FILE_NO_SRCH_PRIV                   = 0x8989;

   /**
    * <p> (NWE_FILE_NO_DEL_PRIV                    = 0x898A)
    * </p>
    */
   public static final int NWE_FILE_NO_DEL_PRIV                    = 0x898A;

   /**
    * <p> (NWE_FILE_NO_RENAME_PRIV                 = 0x898B)
    * </p>
    */
   public static final int NWE_FILE_NO_RENAME_PRIV                 = 0x898B;

   /**
    * <p> (NWE_FILE_NO_MOD_PRIV                    = 0x898C)
    * </p>
    */
   public static final int NWE_FILE_NO_MOD_PRIV                    = 0x898C;

   /**
    * <p> (NWE_FILE_SOME_IN_USE                    = 0x898D)
    * </p>
    */
   public static final int NWE_FILE_SOME_IN_USE                    = 0x898D;

   /**
    * <p> (NWE_FILE_NONE_IN_USE                    = 0x898E)
    * </p>
    */
   public static final int NWE_FILE_NONE_IN_USE                    = 0x898E;

   /**
    * <p> (NWE_FILE_SOME_READ_ONLY                 = 0x898F)
    * </p>
    */
   public static final int NWE_FILE_SOME_READ_ONLY                 = 0x898F;

   /**
    * <p> (NWE_FILE_NONE_READ_ONLY                 = 0x8990)
    * </p>
    */
   public static final int NWE_FILE_NONE_READ_ONLY                 = 0x8990;

   /**
    * <p> (NWE_FILE_SOME_RENAMED_EXIST             = 0x8991)
    * </p>
    */
   public static final int NWE_FILE_SOME_RENAMED_EXIST             = 0x8991;

   /**
    * <p> (NWE_FILE_NONE_RENAMED_EXIST             = 0x8992)
    * </p>
    */
   public static final int NWE_FILE_NONE_RENAMED_EXIST             = 0x8992;

   /**
    * <p> (NWE_FILE_NO_READ_PRIV                   = 0x8993)
    * </p>
    */
   public static final int NWE_FILE_NO_READ_PRIV                   = 0x8993;

   /**
    * <p> (NWE_FILE_NO_WRITE_PRIV                  = 0x8994)
    * </p>
    */
   public static final int NWE_FILE_NO_WRITE_PRIV                  = 0x8994;

   /**
    * <p> (NWE_FILE_READ_ONLY                      = 0x8994)
    * </p>
    */
   public static final int NWE_FILE_READ_ONLY                      = 0x8994;

   /**
    * <p> (NWE_FILE_DETACHED                       = 0x8995)
    * </p>
    */
   public static final int NWE_FILE_DETACHED                       = 0x8995;

   /**
    * <p> (NWE_SERVER_OUT_OF_MEMORY                = 0x8996)
    * </p>
    */
   public static final int NWE_SERVER_OUT_OF_MEMORY                = 0x8996;

   /**
    * <p> (NWE_DISK_NO_SPOOL_SPACE                 = 0x8997)
    * </p>
    */
   public static final int NWE_DISK_NO_SPOOL_SPACE                 = 0x8997;

   /**
    * <p> (NWE_VOL_INVALID                         = 0x8998)
    * </p>
    */
   public static final int NWE_VOL_INVALID                         = 0x8998;

   /**
    * <p> (NWE_DIR_FULL                            = 0x8999)
    * </p>
    */
   public static final int NWE_DIR_FULL                            = 0x8999;

   /**
    * <p> (NWE_VOL_RENAMING_ACROSS                 = 0x899A)
    * </p>
    */
   public static final int NWE_VOL_RENAMING_ACROSS                 = 0x899A;

   /**
    * <p> (NWE_DIRHANDLE_INVALID                   = 0x899B)
    * </p>
    */
   public static final int NWE_DIRHANDLE_INVALID                   = 0x899B;

   /**
    * <p> (NWE_PATH_INVALID                        = 0x899C)
    * </p>
    */
   public static final int NWE_PATH_INVALID                        = 0x899C;

   /**
    * <p> (NWE_TRUSTEES_NO_MORE                    = 0x899C)
    * </p>
    */
   public static final int NWE_TRUSTEES_NO_MORE                    = 0x899C;

   /**
    * <p> (NWE_DIRHANDLE_NO_MORE                   = 0x899D)
    * </p>
    */
   public static final int NWE_DIRHANDLE_NO_MORE                   = 0x899D;

   /**
    * <p> (NWE_FILE_NAME_INVALID                   = 0x899E)
    * </p>
    */
   public static final int NWE_FILE_NAME_INVALID                   = 0x899E;

   /**
    * <p> (NWE_DIR_ACTIVE                          = 0x899F)
    * </p>
    */
   public static final int NWE_DIR_ACTIVE                          = 0x899F;

   /**
    * <p> (NWE_DIR_NOT_EMPTY                       = 0x89A0)
    * </p>
    */
   public static final int NWE_DIR_NOT_EMPTY                       = 0x89A0;

   /**
    * <p> (NWE_DIR_IO_ERROR                        = 0x89A1)
    * </p>
    */
   public static final int NWE_DIR_IO_ERROR                        = 0x89A1;

   /**
    * <p> (NWE_FILE_IO_LOCKED                      = 0x89A2)
    * </p>
    */
   public static final int NWE_FILE_IO_LOCKED                      = 0x89A2;

   /**
    * <p> (NWE_TTS_RANSACTION_RESTARTED            = 0x89A3)
    * </p>
    */
   public static final int NWE_TTS_RANSACTION_RESTARTED            = 0x89A3;

   /**
    * <p> (NWE_DIR_RENAME_INVALID                  = 0x89A4)
    * </p>
    */
   public static final int NWE_DIR_RENAME_INVALID                  = 0x89A4;

   /**
    * <p> (NWE_FILE_OPENCREAT_MODE_INVALID         = 0x89A5)
    * </p>
    */
   public static final int NWE_FILE_OPENCREAT_MODE_INVALID         = 0x89A5;

   /**
    * <p> (NWE_ALREADY_IN_USE                      = 0x89A6)
    * </p>
    */
   public static final int NWE_ALREADY_IN_USE                      = 0x89A6;

   /**
    * <p> (NWE_RESOURCE_TAG_INVALID                = 0x89A7)
    * </p>
    */
   public static final int NWE_RESOURCE_TAG_INVALID                = 0x89A7;

   /**
    * <p> (NWE_ACCESS_DENIED                       = 0x89A8)
    * </p>
    */
   public static final int NWE_ACCESS_DENIED                       = 0x89A8;

   /**
    * <p> (NWE_DATA_STREAM_INVALID                 = 0x89BE)
    * </p>
    */
   public static final int NWE_DATA_STREAM_INVALID                 = 0x89BE;

   /**
    * <p> (NWE_NAME_SPACE_INVALID                  = 0x89BF)
    * </p>
    */
   public static final int NWE_NAME_SPACE_INVALID                  = 0x89BF;

   /**
    * <p> (NWE_ACCTING_NO_PRIV                     = 0x89C0)
    * </p>
    */
   public static final int NWE_ACCTING_NO_PRIV                     = 0x89C0;

   /**
    * <p> (NWE_ACCTING_NO_BALANCE                  = 0x89C1)
    * </p>
    */
   public static final int NWE_ACCTING_NO_BALANCE                  = 0x89C1;

   /**
    * <p> (NWE_ACCTING_NO_CREDIT                   = 0x89C2)
    * </p>
    */
   public static final int NWE_ACCTING_NO_CREDIT                   = 0x89C2;

   /**
    * <p> (NWE_ACCTING_TOO_MANY_HOLDS              = 0x89C3)
    * </p>
    */
   public static final int NWE_ACCTING_TOO_MANY_HOLDS              = 0x89C3;

   /**
    * <p> (NWE_ACCTING_DISABLED                    = 0x89C4)
    * </p>
    */
   public static final int NWE_ACCTING_DISABLED                    = 0x89C4;

   /**
    * <p> (NWE_LOGIN_LOCKOUT                       = 0x89C5)
    * </p>
    */
   public static final int NWE_LOGIN_LOCKOUT                       = 0x89C5;

   /**
    * <p> (NWE_CONSOLE_NO_PRIV                     = 0x89C6)
    * </p>
    */
   public static final int NWE_CONSOLE_NO_PRIV                     = 0x89C6;

   /**
    * <p> (NWE_Q_IO_FAILURE                        = 0x89D0)
    * </p>
    */
   public static final int NWE_Q_IO_FAILURE                        = 0x89D0;

   /**
    * <p> (NWE_Q_NONE                              = 0x89D1)
    * </p>
    */
   public static final int NWE_Q_NONE                              = 0x89D1;

   /**
    * <p> (NWE_Q_NO_SERVER                         = 0x89D2)
    * </p>
    */
   public static final int NWE_Q_NO_SERVER                         = 0x89D2;

   /**
    * <p> (NWE_Q_NO_RIGHTS                         = 0x89D3)
    * </p>
    */
   public static final int NWE_Q_NO_RIGHTS                         = 0x89D3;

   /**
    * <p> (NWE_Q_FULL                              = 0x89D4)
    * </p>
    */
   public static final int NWE_Q_FULL                              = 0x89D4;

   /**
    * <p> (NWE_Q_NO_JOB                            = 0x89D5)
    * </p>
    */
   public static final int NWE_Q_NO_JOB                            = 0x89D5;

   /**
    * <p> (NWE_Q_NO_JOB_RIGHTS                     = 0x89D6)
    * </p>
    */
   public static final int NWE_Q_NO_JOB_RIGHTS                     = 0x89D6;

   /**
    * <p> (NWE_PASSWORD_UNENCRYPTED                = 0x89D6)
    * </p>
    */
   public static final int NWE_PASSWORD_UNENCRYPTED                = 0x89D6;

   /**
    * <p> (NWE_Q_IN_SERVICE                        = 0x89D7)
    * </p>
    */
   public static final int NWE_Q_IN_SERVICE                        = 0x89D7;

   /**
    * <p> (NWE_PASSWORD_NOT_UNIQUE                 = 0x89D7)
    * </p>
    */
   public static final int NWE_PASSWORD_NOT_UNIQUE                 = 0x89D7;

   /**
    * <p> (NWE_Q_NOT_ACTIVE                        = 0x89D8)
    * </p>
    */
   public static final int NWE_Q_NOT_ACTIVE                        = 0x89D8;

   /**
    * <p> (NWE_PASSWORD_TOO_SHORT                  = 0x89D8)
    * </p>
    */
   public static final int NWE_PASSWORD_TOO_SHORT                  = 0x89D8;

   /**
    * <p> (NWE_Q_STN_NOT_SERVER                    = 0x89D9)
    * </p>
    */
   public static final int NWE_Q_STN_NOT_SERVER                    = 0x89D9;

   /**
    * <p> (NWE_LOGIN_NO_CONN                       = 0x89D9)
    * </p>
    */
   public static final int NWE_LOGIN_NO_CONN                       = 0x89D9;

   /**
    * <p> (NWE_LOGIN_MAX_EXCEEDED                  = 0x89D9)
    * </p>
    */
   public static final int NWE_LOGIN_MAX_EXCEEDED                  = 0x89D9;

   /**
    * <p> (NWE_Q_HALTED                            = 0x89DA)
    * </p>
    */
   public static final int NWE_Q_HALTED                            = 0x89DA;

   /**
    * <p> (NWE_LOGIN_UNAUTHORIZED_TIME             = 0x89DA)
    * </p>
    */
   public static final int NWE_LOGIN_UNAUTHORIZED_TIME             = 0x89DA;

   /**
    * <p> (NWE_LOGIN_UNAUTHORIZED_STATION          = 0x89DB)
    * </p>
    */
   public static final int NWE_LOGIN_UNAUTHORIZED_STATION          = 0x89DB;

   /**
    * <p> (NWE_Q_MAX_SERVERS                       = 0x89DB)
    * </p>
    */
   public static final int NWE_Q_MAX_SERVERS                       = 0x89DB;

   /**
    * <p> (NWE_ACCT_DISABLED                       = 0x89DC)
    * </p>
    */
   public static final int NWE_ACCT_DISABLED                       = 0x89DC;

   /**
    * <p> (NWE_PASSWORD_INVALID                    = 0x89DE)
    * </p>
    */
   public static final int NWE_PASSWORD_INVALID                    = 0x89DE;

   /**
    * <p> (NWE_PASSWORD_EXPIRED                    = 0x89DF)
    * </p>
    */
   public static final int NWE_PASSWORD_EXPIRED                    = 0x89DF;

   /**
    * <p> (NWE_LOGIN_NO_CONN_AVAIL                 = 0x89E0)
    * </p>
    */
   public static final int NWE_LOGIN_NO_CONN_AVAIL                 = 0x89E0;

   /**
    * <p> (NWE_E_NO_MORE_USERS                     = 0x89E7)
    * </p>
    */
   public static final int NWE_E_NO_MORE_USERS                     = 0x89E7;

   /**
    * <p> (NWE_BIND_NOT_ITEM_PROP                  = 0x89E8)
    * </p>
    */
   public static final int NWE_BIND_NOT_ITEM_PROP                  = 0x89E8;

   /**
    * <p> (NWE_BIND_WRITE_TO_GROUP_PROP            = 0x89E8)
    * </p>
    */
   public static final int NWE_BIND_WRITE_TO_GROUP_PROP            = 0x89E8;

   /**
    * <p> (NWE_BIND_MEMBER_ALREADY_EXISTS          = 0x89E9)
    * </p>
    */
   public static final int NWE_BIND_MEMBER_ALREADY_EXISTS          = 0x89E9;

   /**
    * <p> (NWE_BIND_NO_SUCH_MEMBER                 = 0x89EA)
    * </p>
    */
   public static final int NWE_BIND_NO_SUCH_MEMBER                 = 0x89EA;

   /**
    * <p> (NWE_BIND_NOT_GROUP_PROP                 = 0x89EB)
    * </p>
    */
   public static final int NWE_BIND_NOT_GROUP_PROP                 = 0x89EB;

   /**
    * <p> (NWE_BIND_NO_SUCH_SEGMENT                = 0x89EC)
    * </p>
    */
   public static final int NWE_BIND_NO_SUCH_SEGMENT                = 0x89EC;

   /**
    * <p> (NWE_BIND_PROP_ALREADY_EXISTS            = 0x89ED)
    * </p>
    */
   public static final int NWE_BIND_PROP_ALREADY_EXISTS            = 0x89ED;

   /**
    * <p> (NWE_BIND_OBJ_ALREADY_EXISTS             = 0x89EE)
    * </p>
    */
   public static final int NWE_BIND_OBJ_ALREADY_EXISTS             = 0x89EE;

   /**
    * <p> (NWE_BIND_NAME_INVALID                   = 0x89EF)
    * </p>
    */
   public static final int NWE_BIND_NAME_INVALID                   = 0x89EF;

   /**
    * <p> (NWE_BIND_WILDCARD_INVALID               = 0x89F0)
    * </p>
    */
   public static final int NWE_BIND_WILDCARD_INVALID               = 0x89F0;

   /**
    * <p> (NWE_BIND_SECURITY_INVALID               = 0x89F1)
    * </p>
    */
   public static final int NWE_BIND_SECURITY_INVALID               = 0x89F1;

   /**
    * <p> (NWE_BIND_OBJ_NO_READ_PRIV               = 0x89F2)
    * </p>
    */
   public static final int NWE_BIND_OBJ_NO_READ_PRIV               = 0x89F2;

   /**
    * <p> (NWE_BIND_OBJ_NO_RENAME_PRIV             = 0x89F3)
    * </p>
    */
   public static final int NWE_BIND_OBJ_NO_RENAME_PRIV             = 0x89F3;

   /**
    * <p> (NWE_BIND_OBJ_NO_DELETE_PRIV             = 0x89F4)
    * </p>
    */
   public static final int NWE_BIND_OBJ_NO_DELETE_PRIV             = 0x89F4;

   /**
    * <p> (NWE_BIND_OBJ_NO_CREATE_PRIV             = 0x89F5)
    * </p>
    */
   public static final int NWE_BIND_OBJ_NO_CREATE_PRIV             = 0x89F5;

   /**
    * <p> (NWE_BIND_PROP_NO_DELETE_PRIV            = 0x89F6)
    * </p>
    */
   public static final int NWE_BIND_PROP_NO_DELETE_PRIV            = 0x89F6;

   /**
    * <p> (NWE_BIND_PROP_NO_CREATE_PRIV            = 0x89F7)
    * </p>
    */
   public static final int NWE_BIND_PROP_NO_CREATE_PRIV            = 0x89F7;

   /**
    * <p> (NWE_BIND_PROP_NO_WRITE_PRIV             = 0x89F8)
    * </p>
    */
   public static final int NWE_BIND_PROP_NO_WRITE_PRIV             = 0x89F8;

   /**
    * <p> (NWE_BIND_PROP_NO_READ_PRIV              = 0x89F9)
    * </p>
    */
   public static final int NWE_BIND_PROP_NO_READ_PRIV              = 0x89F9;

   /**
    * <p> (NWE_NO_FREE_CONN_SLOTS                  = 0x89F9)
    * </p>
    */
   public static final int NWE_NO_FREE_CONN_SLOTS                  = 0x89F9;

   /**
    * <p> (NWE_NO_MORE_SERVER_SLOTS                = 0x89FA)
    * </p>
    */
   public static final int NWE_NO_MORE_SERVER_SLOTS                = 0x89FA;

   /**
    * <p> (NWE_TEMP_REMAP_ERROR                    = 0x89FA)
    * </p>
    */
   public static final int NWE_TEMP_REMAP_ERROR                    = 0x89FA;

   /**
    * <p> (NWE_PARAMETERS_INVALID                  = 0x89FB)
    * </p>
    */
   public static final int NWE_PARAMETERS_INVALID                  = 0x89FB;

   /**
    * <p> (NWE_BIND_NO_SUCH_PROP                   = 0x89FB)
    * </p>
    */
   public static final int NWE_BIND_NO_SUCH_PROP                   = 0x89FB;

   /**
    * <p> (NWE_NCP_NOT_SUPPORTED                   = 0x89FB)
    * </p>
    */
   public static final int NWE_NCP_NOT_SUPPORTED                   = 0x89FB;

   /**
    * <p> (NWE_INET_PACKET_REQ_CANCELED            = 0x89FC)
    * </p>
    */
   public static final int NWE_INET_PACKET_REQ_CANCELED            = 0x89FC;

   /**
    * <p> (NWE_SERVER_UNKNOWN                      = 0x89FC)
    * </p>
    */
   public static final int NWE_SERVER_UNKNOWN                      = 0x89FC;

   /**
    * <p> (NWE_MSG_Q_FULL                          = 0x89FC)
    * </p>
    */
   public static final int NWE_MSG_Q_FULL                          = 0x89FC;

   /**
    * <p> (NWE_BIND_NO_SUCH_OBJ                    = 0x89FC)
    * </p>
    */
   public static final int NWE_BIND_NO_SUCH_OBJ                    = 0x89FC;

   /**
    * <p> (NWE_LOCK_COLLISION                      = 0x89FD)
    * </p>
    */
   public static final int NWE_LOCK_COLLISION                      = 0x89FD;

   /**
    * <p> (NWE_CONN_NUM_INVALID                    = 0x89FD)
    * </p>
    */
   public static final int NWE_CONN_NUM_INVALID                    = 0x89FD;

   /**
    * <p> (NWE_PACKET_LEN_INVALID                  = 0x89FD)
    * </p>
    */
   public static final int NWE_PACKET_LEN_INVALID                  = 0x89FD;

   /**
    * <p> (NWE_UNKNOWN_REQ                         = 0x89FD)
    * </p>
    */
   public static final int NWE_UNKNOWN_REQ                         = 0x89FD;

   /**
    * <p> (NWE_BIND_LOCKED                         = 0x89FE)
    * </p>
    */
   public static final int NWE_BIND_LOCKED                         = 0x89FE;

   /**
    * <p> (NWE_TRUSTEE_NOT_FOUND                   = 0x89FE)
    * </p>
    */
   public static final int NWE_TRUSTEE_NOT_FOUND                   = 0x89FE;

   /**
    * <p> (NWE_DIR_LOCKED                          = 0x89FE)
    * </p>
    */
   public static final int NWE_DIR_LOCKED                          = 0x89FE;

   /**
    * <p> (NWE_SEM_INVALID_NAME_LEN                = 0x89FE)
    * </p>
    */
   public static final int NWE_SEM_INVALID_NAME_LEN                = 0x89FE;

   /**
    * <p> (NWE_PACKET_NOT_DELIVERABLE              = 0x89FE)
    * </p>
    */
   public static final int NWE_PACKET_NOT_DELIVERABLE              = 0x89FE;

   /**
    * <p> (NWE_SOCKET_TABLE_FULL                   = 0x89FE)
    * </p>
    */
   public static final int NWE_SOCKET_TABLE_FULL                   = 0x89FE;

   /**
    * <p> (NWE_SPOOL_DIR_ERROR                     = 0x89FE)
    * </p>
    */
   public static final int NWE_SPOOL_DIR_ERROR                     = 0x89FE;

   /**
    * <p> (NWE_LOGIN_DISABLED_BY_SUPER             = 0x89FE)
    * </p>
    */
   public static final int NWE_LOGIN_DISABLED_BY_SUPER             = 0x89FE;

   /**
    * <p> (NWE_TIMEOUT_FAILURE                     = 0x89FE)
    * </p>
    */
   public static final int NWE_TIMEOUT_FAILURE                     = 0x89FE;

   /**
    * <p> (NWE_FILE_EXT                            = 0x89FF)
    * </p>
    */
   public static final int NWE_FILE_EXT                            = 0x89FF;

   /**
    * <p> (NWE_FILE_NAME                           = 0x89FF)
    * </p>
    */
   public static final int NWE_FILE_NAME                           = 0x89FF;

   /**
    * <p> (NWE_HARD_FAILURE                        = 0x89FF)
    * </p>
    */
   public static final int NWE_HARD_FAILURE                        = 0x89FF;

   /**
    * <p> (NWE_FCB_CLOSE                           = 0x89FF)
    * </p>
    */
   public static final int NWE_FCB_CLOSE                           = 0x89FF;

   /**
    * <p> (NWE_IO_BOUND                            = 0x89FF)
    * </p>
    */
   public static final int NWE_IO_BOUND                            = 0x89FF;

   /**
    * <p> (NWE_BAD_SPOOL_PRINTER                   = 0x89FF)
    * </p>
    */
   public static final int NWE_BAD_SPOOL_PRINTER                   = 0x89FF;

   /**
    * <p> (NWE_BAD_RECORD_OFFSET                   = 0x89FF)
    * </p>
    */
   public static final int NWE_BAD_RECORD_OFFSET                   = 0x89FF;

   /**
    * <p> (NWE_DRIVE_INVALID_NUM                   = 0x89FF)
    * </p>
    */
   public static final int NWE_DRIVE_INVALID_NUM                   = 0x89FF;

   /**
    * <p> (NWE_SEM_INVALID_INIT_VAL                = 0x89FF)
    * </p>
    */
   public static final int NWE_SEM_INVALID_INIT_VAL                = 0x89FF;

   /**
    * <p> (NWE_SEM_INVALID_HANDLE                  = 0x89FF)
    * </p>
    */
   public static final int NWE_SEM_INVALID_HANDLE                  = 0x89FF;

   /**
    * <p> (NWE_NO_FILES_FOUND_ERROR                = 0x89FF)
    * </p>
    */
   public static final int NWE_NO_FILES_FOUND_ERROR                = 0x89FF;

   /**
    * <p> (NWE_NO_RESPONSE_FROM_SERVER             = 0x89FF)
    * </p>
    */
   public static final int NWE_NO_RESPONSE_FROM_SERVER             = 0x89FF;

   /**
    * <p> (NWE_NO_OBJ_OR_BAD_PASSWORD              = 0x89FF)
    * </p>
    */
   public static final int NWE_NO_OBJ_OR_BAD_PASSWORD              = 0x89FF;

   /**
    * <p> (NWE_PATH_NOT_LOCATABLE                  = 0x89FF)
    * </p>
    */
   public static final int NWE_PATH_NOT_LOCATABLE                  = 0x89FF;

   /**
    * <p> (NWE_Q_FULL_ERROR                        = 0x89FF)
    * </p>
    */
   public static final int NWE_Q_FULL_ERROR                        = 0x89FF;

   /**
    * <p> (NWE_REQ_NOT_OUTSTANDING                 = 0x89FF)
    * </p>
    */
   public static final int NWE_REQ_NOT_OUTSTANDING                 = 0x89FF;

   /**
    * <p> (NWE_SOCKET_ALREADY_OPEN                 = 0x89FF)
    * </p>
    */
   public static final int NWE_SOCKET_ALREADY_OPEN                 = 0x89FF;

   /**
    * <p> (NWE_LOCK_ERROR                          = 0x89FF)
    * </p>
    */
   public static final int NWE_LOCK_ERROR                          = 0x89FF;

   /**
    * <p> (NWE_FAILURE                             = 0x89FF)
    * </p>
    */
   public static final int NWE_FAILURE                             = 0x89FF;

}
