/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetDistinguishedNameJNI.h"


#ifdef __cplusplus
extern "C" {
#endif

/* public final class NetDistinguishedName
 *    extends NdsDistinguishedName
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetDistinguishedName)
NetDistinguishedNameCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetDistinguishedName;
   jclass clsNetDistinguishedNameLR;
   //NJCL variables
   pNetDistinguishedName sNetDistinguishedName;

   clsNetDistinguishedNameLR = (*env)->FindClass (env, NETSYNTAXPKG "NetDistinguishedName");
   clsNetDistinguishedName = (*env)->NewGlobalRef (env, clsNetDistinguishedNameLR);
   (*env)->DeleteLocalRef (env, clsNetDistinguishedNameLR);

   sNetDistinguishedName = (pNetDistinguishedName) sysMalloc (sizeof (NetDistinguishedName));

   if (NULL != sNetDistinguishedName)
   {
      // assign jclass variables
      sNetDistinguishedName->cls = clsNetDistinguishedName;

      // assign jfieldID variables
      sNetDistinguishedName->ID.value = (*env)->GetFieldID (env, clsNetDistinguishedName, "value", "Ljava/lang/String;");
   }
   return (sNetDistinguishedName);

} /* NetDistinguishedNameCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetDistinguishedNameCreate
(
   JNIEnv *env,
   pNetDistinguishedName sNetDistinguishedName,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netDistinguishedName = (*env)->AllocObject (env, sNetDistinguishedName->cls);

   {
      jstring value;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netDistinguishedName,
                                 sNetDistinguishedName->ID.value,
                        (jobject)(value = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, value);
   }

   return (netDistinguishedName);

} /* NetDistinguishedNameCreate () */


#ifdef __cplusplus
}
#endif


