/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <unicode.h>

#include <nwalias.h>

#include "jncpWire.h"

#include "NetOctetListJNI.h"


/* public final class NetOctetList
 *    extends NdsOctetList
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected byte[][] value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetOctetList)
NetOctetListCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetOctetList;
   jclass clsNetOctetListLR;
   jclass clsByteArray;
   jclass clsByteArrayLR;
   //NJCL variables
   pNetOctetList sNetOctetList;

   clsByteArrayLR = (*env)->FindClass (env, "[B");
   clsByteArray = (*env)->NewGlobalRef (env, clsByteArrayLR);
   (*env)->DeleteLocalRef (env, clsByteArrayLR);

   clsNetOctetListLR = (*env)->FindClass (env, NETSYNTAXPKG "NetOctetList");
   clsNetOctetList = (*env)->NewGlobalRef (env, clsNetOctetListLR);
   (*env)->DeleteLocalRef (env, clsNetOctetListLR);

   sNetOctetList = (pNetOctetList) sysMalloc (sizeof (NetOctetList));

   if (NULL != sNetOctetList)
   {
      // assign jclass variables
      sNetOctetList->cls = clsNetOctetList;
      sNetOctetList->clsByteArray = clsByteArray;

      // assign jfieldID variables
      sNetOctetList->ID.value = (*env)->GetFieldID (env, clsNetOctetList, "values", "[[B");
   }
   return (sNetOctetList);

} /* NetOctetListCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetOctetListCreate
(
   JNIEnv *env,
   pNetOctetList sNetOctetList,
   pBuf_T buf
)
{
   // JNI variables
   jobjectArray values;
   // NWNet variables
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netOctetList = (*env)->AllocObject (env, sNetOctetList->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      // NWNet variables
      nuint32 i, count;

      count = jncpGetInt32 (env, curPos, limit);

      values = (*env)->NewObjectArray (env, count, sNetOctetList->clsByteArray, NULL);

      for (i = 0; i < count; i++)
      {
         jbyteArray value;
         pnstr8 cValue;
         nuint32 length;

         NAlign32 (curPos);

         cValue = jncpGetData (env, curPos, limit, &length);
         value = (*env)->NewByteArray (env, length); 
         (*env)->SetByteArrayRegion (env, value, 0, length, (jbyte *) cValue); 
         (*env)->SetObjectArrayElement (env, values, (jsize) i, value);
         (*env)->DeleteLocalRef (env, value);
      }
      (*env)->SetObjectField (
                                 env,
                                 netOctetList,
                                 sNetOctetList->ID.value,
                       (jobject) values);

      (*env)->DeleteLocalRef (env, values);
   }

   return (netOctetList);

} /* NetOctetListCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct _OCTET_LIST
 * {
 *    struct _Octet_List   *next;
 *    NWLEN                length;
 *    pnuint8              data;
 * } Octet_List_T;
 *
 * java array:
 *  | count | [size | array]+
 */

N_GLOBAL_FUNC_C (jbyteArray)
NetOctetList_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
//   jclass cls;
//   jmethodID getHandleMid, getSizeMid;
//   jint nhdlMemory, length;
   jbyteArray byteArray;
   // NWNet variables
   pOctet_List_T octetList;
   nuint8 *octetListPtr, *ptr;
   nuint32 count = 0;                        // initialize count

   // NdsMemory methods
//   cls = (*env)->GetObjectClass (env, values);
//   getHandleMid = (*env)->GetMethodID (env, cls, "getHandle", "()I");
//   getSizeMid = (*env)->GetMethodID (env, cls, "getSize", "()I");

   // NdsMemory.handle - ReplicaPointer C struct
//   nhdlMemory = (*env)->CallIntMethod (env, values, getHandleMid);
//   octetList = (pOctet_List_T) nhdlMemory;
   octetList = (pOctet_List_T) cValue;

   // NdsMemory.size - NWNet buffer size
//   length = (*env)->CallIntMethod (env, values, getSizeMid);

   // malloc temporary buffer
//   octetListPtr = (nuint8 *) sysMalloc (length);
   octetListPtr = (nuint8 *) sysMalloc (cLength);
   ptr = octetListPtr + sizeof (nuint32);    // skip count

   // build the temporary buffer
   while (octetList)
   {
      NWLEN length;

      *(NWLEN *) ptr = length = octetList->length;
      ptr += sizeof(NWLEN);

      memcpy (ptr, octetList->data, octetList->length);
      ptr += octetList->length;

      count++;                               // increment count
      octetList = octetList->next;
   }

   *(pnuint32) octetListPtr = count;         // assign count

   // allocate return byte[]
//   byteArray = (*env)->NewByteArray (env, length);
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
//   (*env)->SetByteArrayRegion (env, byteArray, 0, length, (jbyte *) octetListPtr);
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) octetListPtr);

   // free temporary buffer
   sysFree (octetListPtr);

   return (byteArray);

}  /* fromCStruct */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetOctetList_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pOctet_List_T octetList, octetListPtr;
   nuint8 *dataPtr;
   nuint32 count;

   // get byte[]
   byteArray = ptr = (*env)->GetByteArrayElements (env, values, 0);

   // calculate NetMemory size
   count = *(pnuint32) ptr;
   ptr += sizeof(nuint32);
   length = (*env)->GetArrayLength (env, values) + count * sizeof(Octet_List_T);

   // malloc NetMemory buffer
   octetList = octetListPtr = (pOctet_List_T) sysMalloc (length);
   dataPtr = (nuint8 *)(octetList) + sizeof(Octet_List_T);

   // build the buffer
   while (count--)
   {
      octetListPtr->length = *(NWLEN *) ptr;
      ptr += sizeof(NWLEN);

      octetListPtr->data = dataPtr;
      memcpy (octetListPtr->data, ptr, octetListPtr->length);

      if (0 == count)
      {
         break;
      }
      ptr += octetListPtr->length;
      dataPtr += octetListPtr->length;

      octetListPtr->next = (pOctet_List_T) dataPtr;
      dataPtr +=  sizeof(Octet_List_T);
      octetListPtr = octetListPtr->next;
   }
   octetListPtr->next = NULL;

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) octetList);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


