/*
 * @(#)sysmacros_md.h	1.12 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

#ifndef _NW_SYSMACROS_MD_H_
#define _NW_SYSMACROS_MD_H_

// Can use these nwr_ functions to track memory allocations
// so that they can be freed
#define sysMalloc			nwr_malloc
#define sysFree				nwr_free
#define sysCalloc			nwr_calloc
#define sysRealloc			nwr_realloc
#define sysStrdup			nwr_strdup
#define putenv	(*javaPutenv)

void	*nwr_malloc( size_t __size );
void	*nwr_calloc( size_t __n, size_t __size );
void	*nwr_realloc( void *__oldMem, size_t __size );
void	nwr_free( void *__ptr );
char	*nwr_strdup( const char *s1 );
extern	LONG	(*javaPutenv)(char *envstr);


/* A macro for sneaking into a sys_mon_t to get the owner sys_thread_t */
#define sysMonitorOwner(mid)   ((mid)->monitor_owner)

#ifdef DEBUG
#include <setjmp.h>

// Defined within the NetWare JVM
extern int		sjFlag;
extern jmp_buf	sjBuffer;

#define sysAssert(expression) {         \
    if (!(expression)) {                \
        DumpThreads();                  \
        fprintf(stderr,"\"%s\", line %d: assertion failure\n", __FILE__, __LINE__); \
        if ( sjFlag )					\
			longjmp( sjBuffer, 1 );		\
    }                                   \
}
#else
#define sysAssert(expression)
#endif

/*
 * Check whether an exception occurred.  This also gives us the oppor-
 * tunity to use the already-required exception check as a trap for other
 * system-specific conditions.
 */
#define sysCheckException(ee) \
	if (!exceptionOccurred(ee)) { \
	   continue; \
	}

#define sysIsAbsolute(s) ( (*(s) == '/' || *(s) == '\\') || (int)strchr( s+1, ':' ) )

#define sysRmdir(dirp)          rmdir(dirp)

/*
 * Simple, fast recursive lock for the monitor cache.
 */
#include "mutex_md.h"

typedef struct {
    mutex_t mutex;
    long entry_count;
    unsigned long owner;
} cache_lock_t;

/*
 * We do leave the mutex locked across the whole cache lock to avoid
 * the extra unlock and lock that a smaller critical region would entail.
 */
extern cache_lock_t _moncache_lock;
#define sysCacheLockInit() {   mutexInit(&_moncache_lock.mutex);	\
			       _moncache_lock.entry_count = 0;		\
			       _moncache_lock.owner = 0;		\
			   }
#define sysCacheLock()     {   mutexLock(&_moncache_lock.mutex);	\
			       sysAssert(_moncache_lock.entry_count >= 0);\
			       if (_moncache_lock.entry_count++ == 0) {	\
				  _moncache_lock.owner = GetRunningProcess();\
			       }					\
			   }
/* Should not need locking: */
#define sysCacheLocked()   (_moncache_lock.owner == GetRunningProcess())
#define sysCacheUnlock()   {   sysAssert(_moncache_lock.entry_count > 0);\
			       if (--_moncache_lock.entry_count == 0) {	\
				  _moncache_lock.owner = 0;		\
			       }					\
			       mutexUnlock(&_moncache_lock.mutex);	\
			   }

/* The current JIT interface requires sysMonitorExit to be a function */
#define sysMonitorExitLocked(mid)	sysMonitorExit(mid)


#ifdef NWJVM
// For building the NetWare JVM only
#include "nwsys_md.h"
#endif


#endif /*_NW_SYSMACROS_MD_H_*/
