
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/NetObjectInfo.java $
  $Revision: 7 $
  $Modtime: 6/02/00 4:05p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.net;


import java.io.Serializable;

import com.novell.service.nds.NdsObjectInfo;


/** @internal
 *
 */
public final class NetObjectInfo implements NdsObjectInfo, Serializable
{
   private int _objectFlags;
   private int _subordinateCount;
   private int _modificationTime;
   private String _baseClass;
	private boolean _managementRoot = false;

   public NetObjectInfo ()
   {
          this._baseClass = "";
   }

   public NetObjectInfo (
      int objectFlags,
      int subordinateCount,
      int modificationTime,
      String baseClass)
   {
      this._objectFlags = objectFlags;
      this._subordinateCount = subordinateCount;
      this._modificationTime = modificationTime;
      this._baseClass = baseClass;
   }

   public int getObjectFlags ()
   {
      return (_objectFlags);
   }

   public int getSubordinateCount ()
   {
      return (_subordinateCount);
   }

   public int getModificationTime ()
   {
      return (_modificationTime);
   }

   public String getBaseClass ()
   {
      return (_baseClass);
   }

	/**
	 * Does this object represent a Federation Boundary?
	 */
	public boolean isManagementRoot ()
	{
		return (_managementRoot);
	}

   protected void setObjectFlags (int flags)
   {
      _objectFlags = flags;
   }

   protected void setSubordinateCount (int count)
   {
      _subordinateCount = count;
   }

   protected void setModificationTime (int modificationTime)
   {
      _modificationTime = modificationTime;
   }

   protected void setBaseClass (String name)
   {
      _baseClass = name;
   }

	/**
	 * This is set by NetContextFactory after determining if this object is
	 * indeed a Federation_Boundary or "management root" (vs. naming root)
	 */
	public void setManagementRoot (boolean root)
	{
		_managementRoot = root;
	}

} /* NetObjectInfo */

