/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/ncpext/ReferenceFactoryImpl.java $
  $Revision: 3 $
  $Modtime: 4/27/98 12:12p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.ncpext;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.URLParser;
import javax.naming.*;
import java.util.*;

/** @internal
*  Used to create a reference for a NCPExtensionInitialDirContext or
*  a NCPExtensionDirContext.
*/
public class ReferenceFactoryImpl
implements com.novell.utility.naming.spi.ReferenceFactory
{
   /**
   *  Checks Context.PROVIDER_URL in properties for server name.
   *  If NCPExtensionStrings.NCPEXT_NAME is set in properties, returns a
   *  NCPExtensionDirContext reference, otherwise returns a
   *  NCPExtensionInitialDirContext reference.
   *  @param                     props  Passed in properties
   *  @return                    The Reference created if successful
   */
   public Reference createReference(
         Hashtable hash)
      throws NamingException
   {
      Reference ret = null;
		String url = (String)hash.get(Context.PROVIDER_URL);
		String serverName = new URLParser (url).getHost ();
      String extensionName = (String)hash.get(NCPExtensionStrings.NCPEXT_NAME);

      if(null != serverName)
      {
         StringRefAddr host =
            new StringRefAddr(Context.PROVIDER_URL, serverName);
         if(null == extensionName)
         {
            ret = new Reference(
               NCPExtensionStrings.ROOT_EXTENSION_CLASS,
               host,
               NCPExtensionStrings.OBJECT_FACTORY,
               "");
         }
         else
         {
            StringRefAddr extension =
               new StringRefAddr(NCPExtensionStrings.NCPEXT_NAME, extensionName);
            ret = new Reference(
               NCPExtensionStrings.EXTENSION_CLASS,
               host,
               NCPExtensionStrings.OBJECT_FACTORY,
               "");
            ret.add(extension);
         }
         return ret;
      }
      throw new InvalidNameException();
   }
}
