
/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/naming/TransportContextFactoryBuilder.java $
  $Revision: 2 $
  $Modtime: 4/23/98 11:25a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.Hashtable;
import java.util.Properties;

import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/** @internal
 *
 */
public class TransportContextFactoryBuilder implements ContextFactoryBuilder
{
   private static String defaultFactory;
   private static Properties protocolFactories;

   static
   {
      defaultFactory = 
         "com.novell.service.nds.naming.net.NetContextFactory";
      protocolFactories = new Properties ();

      protocolFactories.put (
               Environment.NCP_PROTOCOL,
               "com.novell.service.nds.naming.net.NetContextFactory");
      protocolFactories.put (
               Environment.LDAP_PROTOCOL,
               "com.novell.service.nds.naming.ldap.LdapContextFactory");
   }


   /**
    *
    */
   public TransportContextFactoryBuilder ()
   {

   }

   /**
    *
    */
   public ObjectFactory createObjectFactory (
         Object object,
         Hashtable environment)
   {
      try
      {
         return (createContextFactory (
                     object, 
                     new NdsEnvironment (environment)));
      }
      catch (NamingException e)
      {
         return (null);
      }

   } /* createObjectFactory () */

   /**
    *
    */
   public ContextFactory createContextFactory (
         Object object,
         Environment environment)
      throws NamingException
   {
      String protocol;
      NdsEnvironment ndsEnvironment;

      ndsEnvironment = getEnvironmentInstance (environment);
      protocol = ndsEnvironment.getNdsTransportProtocol ();

      try
      {
         Class cls = Class.forName (getClassName (protocol));

         return ((ContextFactory) cls.newInstance ());
      }
      catch (ClassNotFoundException e)
      {
         return (null);
      }
      catch (InstantiationException e)
      {
         return (null);
      }
      catch (IllegalAccessException e)
      {
         return (null);
      }

   } /* createContextFactory () */

   /**
    *
    */
   public String getClassName (
         String protocol)
   {
      protocol = protocol.toLowerCase ();
      return (protocolFactories.getProperty (protocol, defaultFactory));

   } /* getClassName () */

   /**
    *
    */
   private NdsEnvironment getEnvironmentInstance (
         Environment environment)
      throws NamingException
   {
      if (environment instanceof NdsEnvironment)
      {
         return ((NdsEnvironment) environment);
      }
      else
      {
         return (new NdsEnvironment (environment));
      }

   } /* getEnvironmentInstance () */

} /* TransportContextFactoryBuilder */


