
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetAttributeDefinitionDirContext.java $
  $Revision: 12 $
  $Modtime: 1/28/00 12:40p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.sun.jndi.toolkit.ctx.*;

import com.novell.service.jncp.*;

import com.novell.service.nds.*;
import com.novell.service.nds.NdsAttributeDefinition;
import com.novell.service.nds.NdsAttributeDefinitionInfo;
import com.novell.service.nds.naming.Schema;

import com.novell.service.session.SessionException;
import com.novell.service.jncpv2.net.*;

import com.novell.utility.naming.directory.NAttributes;
import com.novell.utility.naming.directory.SingleValueAttribute;


/** @internal
 * <p> Attributes include:
 * <p> Syntax ID
 * <p> Lower Limit
 * <p> Upper Limit
 * <p> ASN1Name
 * <p> Flags (this may contain one or more of the following)
 * <p>
 * <p> SchemaAttributeDirContext.DS_SINGLE_VALUED_ATTR
 * <p> SchemaAttributeDirContext.DS_SIZED_ATTR
 * <p> SchemaAttributeDirContext.DS_NONREMOVABLE_ATTR
 * <p> SchemaAttributeDirContext.DS_READ_ONLY_ATTR
 * <p> SchemaAttributeDirContext.DS_HIDDEN_ATTR
 * <p> SchemaAttributeDirContext.DS_STRING_ATTR
 * <p> SchemaAttributeDirContext.DS_SYNC_IMMEDIATE
 * <p> SchemaAttributeDirContext.DS_PUBLIC_READ
 * <p> SchemaAttributeDirContext.DS_SERVER_READ
 * <p> SchemaAttributeDirContext.DS_WRITE_MANAGED
 * <p> SchemaAttributeDirContext.DS_PER_REPLICA
 *
 */
public class NetAttributeDefinitionDirContext
      extends NetSchemaDefinitionDirContext
      implements NdsAttributeDefinition, SchemaAttribute
{
   private static Vector attrItemsAttrIDs = new Vector ();
   private NetAttrInfo attrInfo = null;

   /**
    * Static intitializer.  This fills a vector with this context's
    * Attribute ID's
    */
   static
   {
      attrItemsAttrIDs.addElement (ATTR_FLAGS);
      attrItemsAttrIDs.addElement (ATTR_SYNTAX_ID);
      attrItemsAttrIDs.addElement (ATTR_LOWER_LIMIT);
      attrItemsAttrIDs.addElement (ATTR_UPPER_LIMIT);
      attrItemsAttrIDs.addElement (ATTR_ASN1NAME);
   }


   /**
    * Constructor.
    *
    * @param objectName    Distinguished name of this object
    * @param baseClass     NDS class name
    * @param netEnvironment properties to be set in this objects environment
    *
   protected NetAttributeDefinitionDirContext (
         String objectName,
         String baseClass,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, baseClass, netEnvironment);

   } *  */

   /**
    * Constructor.
    *
    * @param objectName    Distinguished name of this object
    * @param baseClass     NDS class name
    * @param netEnvironment properties to be set in this objects environment
    */
   protected NetAttributeDefinitionDirContext (
         String objectName,
         NetAttrInfo attrInfo,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, Schema.SCHEMA_ATTRIBUTE, netEnvironment);

      this.attrInfo = attrInfo;
   }

   /* ***********************************************************************
    * protected Toolkit DirContext methods
    ************************************************************************/

   /**
    *
    */
   protected Attributes c_getAttributes (
         Name name,
         String[] attrIds,
         Continuation cont)
      throws NamingException
   {
/* this is done for us by NetSchemaDefinitionDirContext.p_resolveIntermediate
      if (!name.isEmpty ())
      {
         cont.setError (this, name);
         throw (cont.fillInException (new InvalidNameException ()));
      }
*/

      Attributes result;

      if (null == attrIds)
      {
         result = getAttributes ();
      }
      else
      {
         Attributes attributes = getAttributes ();
         Attribute attribute;

         result = new NAttributes (true);

         for (int i = 0; i < attrIds.length; i++)
         {
            if ((attribute = attributes.get (attrIds[i])) != null)
            {
               result.put (attribute);
            }
         }
      }
      return (result);

   } /* c_getAttributes () */

   /**
    * Currently, the back end doesn't support attribute definition
    * modification.
    */
   protected void schema_modifyAttributes (
         ModificationItem[] mods,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, "");
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /**
    * Currently, the back end doesn't support attribute definition
    * modification.
    */
   public void schema_modifyAttributes (
         int mod_op,
         Attributes attrs,
         Continuation cont)
      throws NamingException
   {
      cont.setError (this, "");
      throw cont.fillInException (new OperationNotSupportedException ());
   }

   /* ***********************************************************************
    * Utility methods
    ************************************************************************/

   /**
    * Returns an instance of this object through the factory
    */
   protected Object getInstance ()
      throws NamingException
   {
      return (factory.getContextInstance (
                           getDistinguishedName (),
                           attrInfo,
                           environment));
   }

   /**
    *
    */
   protected Hashtable getAttrItems ()
      throws NamingException
   {

//NOTE: NetSchemaDirContext.a_getAttributes() not used

      throw (new NamingException ());
   }

   /**
    *
    */
   protected Attributes getAttributes ()
      throws NamingException
   {
      Attributes attributes = new NAttributes (true);

      // Build flags attribute
      attributes.put (new SingleValueAttribute(
                     ATTR_FLAGS,
                     new NdsInteger (attrInfo.getFlags ())));

      // Build syntax attribute
      attributes.put (new SingleValueAttribute(
                     ATTR_SYNTAX_ID,
                     new NdsInteger (attrInfo.getSyntaxID ())));

      // Build lower limit attribute
      attributes.put (new SingleValueAttribute(
                     ATTR_LOWER_LIMIT,
                     new NdsInteger (attrInfo.getLowerLimit ())));

      // Build flags attribute
      attributes.put (new SingleValueAttribute(
                     ATTR_UPPER_LIMIT,
                     new NdsInteger (attrInfo.getUpperLimit ())));

      // Build asn1name attribute
      attributes.put (new SingleValueAttribute(
                     ATTR_ASN1NAME,
                     new NdsOctetString (attrInfo.getASN1ID ())));

      return (attributes);

   } /* getAttributes () */


   // ****************** NdsAttributeDefinition Interface ******************

   /**
    *
    */
   public NdsAttributeDefinitionInfo getAttributeInfo ()
      throws NSIException
   {
      return (attrInfo);
   }

} /* NetAttributeDefinitionDirContext */


