
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetBackLink.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;

import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsBackLink;


/** @internal
 * NetBackLink is an Adapter for NdsBackLink.
 * This class converts to/from the NWNet Back_Link_T.
 *
 * API Data Structure:
 *    typedef struct
 *    {
 *       NWOBJ_ID remoteID;
 *       pnchar     objectName;
 *    } Back_Link_T;
 */
public final class NetBackLink
   extends NdsBackLink implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Back Link from the "API Data Structure".
    *
    * @param   value   byte[] containing a Back_Link_T
    */
   protected NetBackLink (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream eis = new EndianInputStream (value);

         this.remoteId = eis.readLoHiInt ();
         this.objectName = eis.readLoHiChars ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetBackLink adapter for an NdsBackLink.
    *
    * @param   value   an NdsBackLink object.
    */
   protected NetBackLink (
         NdsBackLink value)
   {
      super (value);
   }

   /**
    * Returns a Back Link "API Data Structure".
    *
    * @return   byte[] containing Back_Link_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (this.remoteId);
         eos.writeLoHiChars (this.objectName);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetBackLink */


