
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetTypedName.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsTypedName;


/** @internal
 * NetTypedName is an Adapter for NdsTypedName.
 *
 * This class converts to/from the NWNet Typed_Name_T.
 *
 * API Data Structure:
 *    typedef struct
 *    {
 *       pnchar            objectName;
 *       NWDS_TYPE_LEVEL   level;
 *       NWDS_INTERVAL     interval;
 *
 *    } Typed_Name_T;
 */
public final class NetTypedName
   extends NdsTypedName implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Typed Name from the "API Data Structure".
    *
    * @param   value   byte[] containing a Typed_Name_T
    */
   protected NetTypedName (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.objectName = edis.readLoHiChars ();
         this.level = edis.readLoHiInt ();
         this.interval = edis.readLoHiInt ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetTypedName adapter for an NdsTypedName.
    *
    * @param   value   an NdsTypedName object.
    */
   protected NetTypedName (
         NdsTypedName value)
   {
      super (value);
   }

   /**
    * Returns a Typed Name "API Data Structure".
    *
    * @return   byte[] containing Typed_Name_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.objectName);
         eos.writeLoHiInt (this.level);
         eos.writeLoHiInt (this.interval);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
    }

} /* NetTypedName */


