/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/QueueJobListReply.java $
  $Revision: 6 $
  $Modtime: 4/02/99 3:33p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms;


/** @internal
 * This is an implementation class that handles a queue job list reply.
 *
 * <p>The server returns an array of job numbers.
 * </p>
 */

public class QueueJobListReply
{
   // Private Instance Variables =============================================
   int      totalQueueJobs;
   int      replyQueueJobNumbers;
   int[]    jobNumberList;

   // Constructors ===========================================================

   public QueueJobListReply()
   {
      this.jobNumberList = new int[250];
   }

   // Public set methods =====================================================

   public void setTotalQueueJobs(int totalQueueJobs)
   {
      this.totalQueueJobs = totalQueueJobs;
   }

   public void setReplyQueueJobNumbers(int replyQueueJobNumbers)
   {
      this.replyQueueJobNumbers = replyQueueJobNumbers;
   }

   public void setJobNumberList(int[] jobNumberList)
   {
      int size = jobNumberList.length < this.jobNumberList.length ?
            jobNumberList.length : this.jobNumberList.length;
      System.arraycopy( jobNumberList, 0, this.jobNumberList, 0, size );
   }

   // Public get methods =====================================================
   public int getTotalQueueJobs()
   {
      return(this.totalQueueJobs);
   }
   public int getReplyQueueJobNumbers()
   {
      return(this.replyQueueJobNumbers);
   }
   public int[] getJobNumberList()
   {
      int[] retArray = new int[this.jobNumberList.length];
      System.arraycopy( this.jobNumberList, 0, retArray, 0, retArray.length );
      return( retArray );
   }

} /* class QueueJobListReply */
