/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/qms/naming/QMSNameParser.java $
  $Revision: 6 $
  $Modtime: 1/21/00 10:43a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;


import javax.naming.*;
import java.util.Properties;


/**
 * Provides the rules for parsing names in the QMS naming system. It
 * parses strings to names using the left_to_right naming convention.
 */
public class QMSNameParser implements NameParser
{
   static Properties mySyntax = new Properties();

   static
   {
      mySyntax.put ("jndi.syntax.direction", "left_to_right");
      mySyntax.put ("jndi.syntax.separator", "/");
      mySyntax.put ("jndi.syntax.ignorecase", "true");
      mySyntax.put ("jndi.syntax.escape", "\\");
      mySyntax.put ("jndi.syntax.beginquote", "\"");
      mySyntax.put ("jndi.syntax.separator.ava", "+");
      mySyntax.put ("jndi.syntax.separator.typeval", "=");
      mySyntax.put ("jndi.syntax.trimblanks", "true");
   };

  /**
   *  Constructs a QMSNameParser object with no parameters.
   */
   public QMSNameParser ()
   {
   }

  /**
   *  Returns the Name parsed from the input name String.
   *
   * @param name The name to be parsed input as a String.
   *
   * @return The parsed Name object.
   *
   * @exception NamingException 
   */
   public Name parse (
         String name)
      throws NamingException
   {
      return (new CompoundName (name, mySyntax));
   }

}


