/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/naming/QMSQueueJobAttributes.java $
  $Revision: 3 $
  $Modtime: 4/27/98 11:17a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;


import javax.naming.*;
import javax.naming.directory.*;
import java.util.*;

import com.novell.service.qms.*;

import com.novell.utility.naming.directory.*;

/** @internal
 *
 * public class QMSQueueJobAttributes
 *     extends Attributes
 *
 */

public class QMSQueueJobAttributes extends NAttributes
{
   /*
   * Array of attribute ids of the QMSQueueDirContext object
   */
   private static String[] attrNames =
        { QMSStrings.QUEUE_JOB_ATTRID_CLIENTSTATION,
          QMSStrings.QUEUE_JOB_ATTRID_CLIENTTASK,
          QMSStrings.QUEUE_JOB_ATTRID_CLIENTID,
          QMSStrings.QUEUE_JOB_ATTRID_TARGETSERVERID,
          QMSStrings.QUEUE_JOB_ATTRID_TARGETEXECUTIONTIME,
          QMSStrings.QUEUE_JOB_ATTRID_ENTRYTIME,
          QMSStrings.QUEUE_JOB_ATTRID_ID,
          QMSStrings.QUEUE_JOB_ATTRID_TYPE,
          QMSStrings.QUEUE_JOB_ATTRID_POSITION,
          QMSStrings.QUEUE_JOB_ATTRID_CONTROLFLAGS,
          QMSStrings.QUEUE_JOB_ATTRID_DESCRIPTION };

   private QMSJob job;

   protected QMSQueueJobAttributes( QMSJob job, String[] attrIDs )
      throws NamingException
   {
      super();
      this.job = job;

      if ( null != attrIDs )
      {
         for ( int i = 0; i < attrIDs.length; i++ )
         {
            put( new QMSQueueJobAttribute( attrIDs[i], job ) );
         }
      }
      else
         for ( int i = 0; i < attrNames.length; i++ )
            put( new QMSQueueJobAttribute( attrNames[i], job ) );
   }
}
