/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/naming/QueueInitialContextFactory.java $
  $Revision: 2 $
  $Modtime: 4/08/98 11:20a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;

import javax.naming.*;
import javax.naming.spi.*;
import java.util.*;

/** @internal
* Creates a QueueDirContext corresponding to the
* com.novell.utility.java.naming.Environment.SERVICE_HOST, and
* ( com.novell.service.qms.naming.QMSEnvironment.QUEUE_NAME + 
* com.novell.service.qms.naming.QMSEnvironment.QUEUE_TYPE ) or
* com.novell.service.qms.naming.QMSEnvironment.QUEUE_ID settings in info
*/
public class QueueInitialContextFactory
implements javax.naming.spi.InitialContextFactory
{
   public Context getInitialContext(
         Hashtable info)
      throws NamingException
	{
      try
      {
         Context ctx = (Context)NamingManager.getObjectInstance(
            new com.novell.service.qms.naming.ReferenceFactoryImpl().
               createReference(info),
            null, null, 
            info);
            
         if (ctx == null)
         {
            throw new NameNotFoundException();
         }
         
         return ctx;
      }
      catch(Exception e)
      {
         NamingException ne = new NameNotFoundException();
         ne.setRootCause(e);
         throw ne;
      }
	}
}
