/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/security/protocols/nls/I2L.java $
  $Revision: 9 $
  $Modtime: 1/20/00 12:58p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.security.protocols.nls;

import java.util.ResourceBundle;
import java.util.Locale;

/** @internal
 *
 * The internationalization to localization resource mapper
 * for the this package.
 *
 * @author Jan Sture Nielsen
 * @version 1.0.0 98/03/04
 */
public class I2L
{
   /**
    * related resource bundle
    */
   final static ResourceBundle res = getBundle();

    private static final ResourceBundle getBundle()
    {
	 ResourceBundle res;
   	 try {
	 	res = ResourceBundle.getBundle("com.novell.service.security.protocols.nls.LF");
	 } catch (java.lang.Throwable x) {
	 // Try to get it for the default locale, instead of failing over
	 	res = ResourceBundle.getBundle("com.novell.service.security.protocols.nls.LF",Locale.ENGLISH);
	 }
	 return res;
	}
	 	
	 
	 	
   /**
    * return localized string given the internationalized key
    *
    * @param      key      international key from the resource bundle
    * @return     localized string corresponding to internationalized key
    */
   public static String getString(String key)
   {
      return res.getString(key);
   }

   /**
    * return localized object given the internationalized key
    *
    * @param      key      international key from the resource bundle
    * @return     localized object corresponding to internationalized key
    */
   public static Object getObject(String key)
   {
      return res.getObject(key);
   }
}
