/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerDescriptionImpl.java $
  $Revision: 10 $
  $Modtime: 1/28/00 12:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import javax.naming.*;
import javax.naming.directory.*;
import com.novell.service.jncp.*;
import com.novell.service.session.*;
import com.novell.service.session.xplat.*;
import com.novell.service.rfc1960.SearchStringComponent;

/**
* Provides the Attribute value of an attribute of a ServerDirContext.
*
* @see ServerDescription
*/
public class ServerDescriptionImpl implements
com.novell.utility.naming.directory.StaticAttributeValue,
com.novell.service.server.ServerDescription
{
   private String companyName;
   private String revision;
   private String revisionDate;
   private String copyrightNotice;
   private Session session;
   private boolean empty = true;

  /**
   * Constructs a ServerDescriptionImpl attribute value. This
   * constructor is used to manually create attributes for methods
   * such as search().
   */
   public ServerDescriptionImpl()
   {
   }

   /** @internal
   * Constructs this attribute value and stores the session to the server.
   * This constructor is for use by ServerDirContext
   * @param session The session to the server this attribute is for.
   */
   protected ServerDescriptionImpl(
         Session session)
   {
      this.session = session;
   }

   /**
    * Returns the name of the company providing the version of
    * NetWare.
    * 
    * @return The name of the company providing the version of
    *         the NetWare OS.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public String getCompanyName() throws NSIException
   {
      if(empty)
         getFileServerDescription();
      return companyName;
   }

   /**
    * Returns the version of the server and revision description string.
    *
    * @return The server's version and revision description string.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public String getRevision() throws NSIException
   {
      if(empty)
         getFileServerDescription();
      return revision;
   }

   /**
    * Returns the revision date of the server.
    *
    * @return The server's revision date in the form of mm/dd/yyyy.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public String getRevisionDate() throws NSIException
   {
      if(empty)
         getFileServerDescription();
      return revisionDate;
   }

   /**
    * Returns the copyright notice of the server.
    *
    * @return The server's copyright notice.
    *
    * @exception NSIException When an error occurs retrieving the 
    *                         information.
    */
   public String getCopyrightNotice() throws NSIException
   {
      if(empty)
         getFileServerDescription();
      return copyrightNotice;
   }

   /**
    * Sets the name of the company providing the version of the
    * NetWare OS as the search value. This is used to search for
    * all servers matching the value parameter.
    * 
    * @param value The name of the company providing the version of
    *              NetWare.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setCompanyName(
         String value)
      throws NSIException
   {
      if(empty)
         getFileServerDescription();
      companyName = value;
   }

   /**
    * Sets the version of the server and revision description string
    * as the search value. This is used to search for all servers
    * matching the value parameter.
    * 
    * @param value The server's version and revision description string.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setRevision(
         String value)
      throws NSIException
   {
      if(empty)
         getFileServerDescription();
      revision = value;
   }

   /**
    * Sets the server's revision date in the form of mm/dd/yyyy
    * as the search value. This is used to search for all servers
    * matching the value parameter.
    * 
    * @param value the revision date of the server.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setRevisionDate(
         String value)
      throws NSIException
   {
      if(empty)
         getFileServerDescription();
      revisionDate = value;
   }

   /**
    * Sets the copyright notice of the server as the search value.
    * This is used to search for all servers matching the value
    * parameter.
    * 
    * @param value The server's copyright notice.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setCopyrightNotice(
         String value)
      throws NSIException
   {
      if(empty)
         getFileServerDescription();
      copyrightNotice = value;
   }

   /**
   * Get service from the session and fill in the instance values
   */
   private void getFileServerDescription() throws NSIException
   {
      empty = false;
      //only call if valid session. This allows users to new()
      // instances of this class for search()
      if(session == null)
         return;
      StringBuffer sCompanyName = new StringBuffer();
      StringBuffer sRevision = new StringBuffer();
      StringBuffer sRevisionDate = new StringBuffer();
      StringBuffer sCopyrightNotice = new StringBuffer();

      try
      {
         ((CallsService)session.getService(
            CallsService.KEY)).getFileServerDescription(
            sCompanyName, sRevision, sRevisionDate, sCopyrightNotice);
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }

      companyName = sCompanyName.toString();
      revision = sRevision.toString();
      revisionDate = sRevisionDate.toString();
      copyrightNotice = sCopyrightNotice.toString();
   }

   /** @internal
   */   
   public Attribute buildAttribute() throws NamingException
   {
      return new BasicAttribute(ATTR_ID, this);
   }

   /** @internal
   */   
   public String getID()
   {
      return ATTR_ID;
   }

   /** @internal
   */   
   public boolean compare(
         SearchStringComponent ssc)
      throws NamingException
   {
      int opType = ssc.getOperationType();
      if(opType == SearchStringComponent.PRESENT)
         return true;
      if(opType == SearchStringComponent.EQUALS)
         return equals(ssc.getReplacementObject());
      return false;
   }

   /** @internal
   */   
   public boolean equals(
         Object compObject)
   {
      if(compObject== null || !(compObject instanceof ServerDescriptionImpl) )
         return false;
      ServerDescriptionImpl obj = (ServerDescriptionImpl)compObject;
      if(obj == this)
         return true;
      try
      {
         if(empty)
            getFileServerDescription();
         if(companyName == obj.getCompanyName() &&
            revision == obj.getRevision() &&
            revisionDate == obj.getRevisionDate() &&
            copyrightNotice == obj.getCopyrightNotice() )
         {
            return true;
         }
         return false;
      }
      catch(NSIException e)
      {
         return false;
      }
   }

   // Server does not support modifying attributes
   // so all of the following methods are not supported.
   /** @internal
   */   
   public void addAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void deleteAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void modifyAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public boolean hasMoreElements()
   {
      return false;
   }

   /** @internal
   */   
   public Object nextElement()
   {
      throw new java.util.NoSuchElementException();
   }

   /** @internal
   */   
   public Object getStaticInterface()
   {
      return this;
   }
}
