/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerLoginStatus.java $
  $Revision: 9 $
  $Modtime: 1/28/00 12:46p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import com.novell.service.jncp.NSIException;

/**
 * Provides a specific attribute of a ServerDirContext. The ID of
 * the attribute is equal to ATTR_ID, and the value is an object
 * that implements this interface.
 */
public interface ServerLoginStatus
{
   /**
   *  The attribute ID of this attribute.
   *  The value of this constant is "ServerLoginStatus."
   */
   public final static String ATTR_ID = "ServerLoginStatus";

   /**
   *  @deprecated
   *  This member will be removed. Use ATTR_ID instead.
   */
   public final static String attrID = ATTR_ID;

   /**
    * Determines if the server is allowing logins.
    *
    * @return A boolean set to TRUE if the server is allowing logins;
    *         otherwise set to FALSE.
    *
    * @exception NSIException When an error occurs retrieving the
    *                         information.
    */
   public boolean getStatus() throws NSIException;

   /**
    * Sets the state of the login status.
    *
    * @param value The desired login state as a boolean; TRUE if
    *              the server is allowing logins; otherwise
    *              set to FALSE.
    */
   public void setStatus(
         boolean value)
      throws NSIException;
}
