/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/spi/SessionImpl.java $
  $Revision: 27 $
  $Modtime: 1/08/02 10:09a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import java.util.Vector;
import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.session.bindery.BinderyInitialSessionFactory;
import com.novell.service.session.nds.NDSInitialSessionFactory;
import com.novell.service.session.xplat.*;
import com.novell.service.session.util.JVMUID;
import com.novell.service.session.util.TwoWayHashtable;
import com.novell.java.security.*;
import java.rmi.server.UID;

/** @internal
 * Holds state of Session and decorates SessionState as a Session.
 *
 * All other operations are implemented using states.
 */
public class SessionImpl
implements Session
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean LOCK_DEBUG = false;
   final static private boolean ENTRY_DEBUG = false;
   final static private boolean EXIT_DEBUG = false;
	final static private boolean OPEN_CLOSE_DEBUG = false;  // Open/Close only
   final static private boolean I_DEBUG = false; // Ignore exception
   final static private boolean S_DEBUG = false; // May have side effects
   final static private boolean METHOD_TRACE_DEBUG = false;
   final static private boolean SERVICE_DEBUG = false;
   final static private boolean SESSION_DEBUG = false;

   // Print message if deprecated API is used
   final static private boolean ERROR_ON_DEPRECATED = false;

   protected SessionState state;
   protected UID uid;
   protected SessionEnv environment;
   protected Session parent;
   protected String domainName;
   protected Children children = null;
   private Thread owner = null;
   private int    lockCount = 0;


   /**
    * Used by Sessions to create Session instance.
    */
   public SessionImpl
   (
      Session parent,
      String domainName
   )
   throws SessionException
   {
      this(parent, domainName, new SessionEnv());
   }

   /**
    * Used by Sessions to create Session instance.
    */
   public SessionImpl
   (
      Session parent,
      String domainName,
      SessionEnv environment
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + domainName);
      state = InvalidSessionState.getInstance();
      this.environment = environment;
      this.parent = parent;
      this.domainName = domainName;
      this.children = new Children();

      // Assign unique id to this session
      JVMUID jvmUid = JVMUID.getInstance();
      uid = jvmUid.createUID();
//      jvmUid.write(uid, this);
   }

   public void setState
   (
      SessionState newState
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      if (DEBUG || OPEN_CLOSE_DEBUG)
      {
         if (newState instanceof InvalidSessionState &&
             this.state != null)
            Debug.println("Killing..." + this);
      }
      this.state = newState;
      if (DEBUG || OPEN_CLOSE_DEBUG)
      {
         if (!(newState instanceof InvalidSessionState))
            Debug.println("Creating..." + this);
      }
   }

   public SessionState getState
   (
   )
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getState()");
         }
         return this.state;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getDomainName
    */
   public String getDomainName
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getDomainName()");
         }
         return domainName;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#close
    */
   public void close
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG || OPEN_CLOSE_DEBUG)
         {
            Debug.println("Closing..." + this);
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }

         this.getState().close();

         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getSession
    */
   public Session getSession
   (
      String domainName
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getSession(String): " + domainName);
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         Session s = getSession(
            domainName,
            new SessionEnv());
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return s;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getSession
    */
   public Session getSession
   (
      String domainName,
      SessionEnv environment
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getSession(String, SessionEnv): " + domainName);
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         Session s = this.getState().
            getSession(domainName, environment);
         if (DEBUG || SESSION_DEBUG)
         {
            Debug.println("Session obtained: " + s);
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return s;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getSession
    */
   public Session getSessionTop
   (
      String domainName
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getSessionTop(String)");
         }
         Session s = getSessionTop(
            domainName,
            new SessionEnv());
         return s;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getSessionTop
    */
   public Session getSessionTop
   (
      String domainName,
      SessionEnv environment
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getSessionTop(String, SessionEnv)");
         }
         Session s = this.getState().
            getSessionTop(domainName, environment);
         return s;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes()
    */
   public SessionAttrs getAttributes
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getAttributes()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }

         SessionAttrs attributes = this.getState().
            getAttributes();

         String attrIds[] =
         {
            Authenticatable.IS_AUTHENTICATED_ATTR_ID,
            Session.UID_ATTR_ID
         };
         attributes.modify(
            getImplAttrs(attrIds));

         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }

         return attributes;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes(String[])
    */
   public SessionAttrs getAttributes
   (
      String attrIds[]
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getAttributes(String[])");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }

         // Get this impl's attributes - take first precedence
         SessionAttrs attributes = getImplAttrs(attrIds);

         // Optimization: only get attributes if not all found yet
         if (attributes.count() != attrIds.length)
         {
            // Get this state's attributes but don't override impl's
            attributes.merge(
               this.getState().
                  getAttributes(attrIds));
         }

         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }

         return attributes;
      }
      finally
      {
         unlock();
      }
   }

   private SessionAttrs getImplAttrs
   (
      String attrIds[]
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getImplAttrs()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         // Get inherited attributes
         SessionAttrs attributes = new SessionAttrs();

         // Override with this session's
         for (int i = 0; i < attrIds.length; i++)
         {
            if (Authenticatable.IS_AUTHENTICATED_ATTR_ID.equals(attrIds[i]))
            {
               attributes.modify(
                  Authenticatable.IS_AUTHENTICATED_ATTR_ID,
                  new Boolean(
                     isAuthenticated()));
            }
            if (Session.UID_ATTR_ID.equals(attrIds[i]))
            {
               attributes.modify(
                  Session.UID_ATTR_ID,
                  uid.toString());
            }
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return attributes;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    */
   public SessionEnv getEnvironment
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getEnvironment()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         SessionEnv environment = (SessionEnv)this.environment.clone();
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return environment;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    */
   public SessionEnv getEffectiveEnvironment
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getEffectiveEnvironment()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         SessionEnv environment = (SessionEnv)this.environment.clone();
         try
         {
            if (hasParent())
            {
               if (DEBUG)
               {
                  Debug.println("SI.getEffectiveEnvironment(): MYSELF=" +
                     this.toString());
               }
               environment.merge(
                  getParent().
                     getEffectiveEnvironment());
            }
         }
         catch (InvalidStateException e)
         {
            if (I_DEBUG)
            {
               Debug.ignoreException(e);
            }
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return environment;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    */
   public SessionEnv setEnvironment
   (
      SessionEnv environment
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.setEnvironment()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         SessionEnv old = this.environment;
         this.environment = (SessionEnv)environment.clone();

         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return old;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#search
    */
   public SessionEnumerator search
   (
      SessionAttrs matchingSessionAttrSet
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.search()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         SessionEnumerator enum = this.getState().
            search(matchingSessionAttrSet);
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return enum;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getChildren
    */
   public SessionEnumerator getChildren
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getChildren()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         SessionEnumerator enum = new SessionEnumerator(
            this.children.sessions());
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return enum;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getParent
    */
   public Session getParent
   (
   )
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      return parent;
   }

   /**
    * Internal non-recursive invalidate of this session
    *
    */
   protected void invalidateSelf
   (
      Throwable rootCause  //non null if invalidating as the result of an exception (as opposed to someone calling close() )
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.invalidateSelf() {" + this + "]");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }

         if (hasParent())
            ((SessionImpl)getParent()).
               removeChild(this);

         new InvalidSessionState(this, rootCause);

         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#invalidate
    */
   public void invalidate
   (
      Throwable rootCause //non null if invalidating as the result of an exception (as opposed to someone calling close() )
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.invalidate() {" + this + "]");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }

         SessionImpl child = this;

         try
         {
            // Tell each child to invalidate itself
            SessionEnumerator enum = child.getChildren();
            while (enum.hasMoreElements())
            {
               enum.next().
                  invalidate(rootCause);
            }
            // This invalidate does NOT recurse through children
            ((SessionImpl)child).invalidateSelf(rootCause);
         }
         catch (Exception e)
         {
            if (I_DEBUG)
            {
               Debug.ignoreException(e);
            }
         }

         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#validateLinks
    */
   public void validateLinks
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.validateLinks()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         this.getState().validateLinks();
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#isValid
    */
   public boolean isValid()
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         return this.getState().isValid();
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getService
    */
   public SessionService getService
   (
      String serviceKey
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG || SERVICE_DEBUG)
         {
            Debug.println("Getting service: " + serviceKey);
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         SessionService service = this.getState().
            getService(serviceKey);
         if (DEBUG || SERVICE_DEBUG)
         {
            Debug.println("Service acquired: " + this.getState());
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return service;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session.
    *
    * @see Session#getUID
    */
   public UID getUID
   (
   )
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.getUID()");
         }
         return uid;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session.
    *
    * @exception SessionException Or a subclass thereof.
    */
   public boolean hasParent
   (
   )
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      return (null != parent);
   }

   /**
    * Inherited from Session.
    *
    * @exception SessionException Or a subclass thereof.
    */
   public boolean hasChildren
   (
   )
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.hasParent()");
         }
         return (!this.children.isEmpty());
      }
      finally
      {
         unlock();
      }
   }

   public void addChild
   (
      SessionImpl child
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         this.children.addChild(child);
      }
      finally
      {
         unlock();
      }
   }

   public void removeChild
   (
      SessionImpl child
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         this.children.removeChild(child);
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Return direct-descendant child session
    */
   public Session getChild(String domainName)
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         return children.get(domainName);
      }
      finally
      {
         unlock();
      }
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable
    *
    * @see Authenticatable#getName
    */
   public String getName
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (ERROR_ON_DEPRECATED)
         {
            System.out.println("This API has been deprecated..." +
               "see documentation for more details. Stack trace follows:");
            Thread.dumpStack();
         }

         if (DEBUG)
         {
            Debug.println("SI.getName()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         String name = (this.getState()).getName();
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return name;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable
    *
    * @see Authenticatable#authenticate()
    */
   public void authenticate
   (
      String name
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (ERROR_ON_DEPRECATED)
         {
            System.out.println("This API has been deprecated..." +
               "see documentation for more details. Stack trace follows:");
            Thread.dumpStack();
         }

         if (DEBUG)
         {
            Debug.println("SI.authenticate(): " + name);
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         this.getState().
            authenticate(name);
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
      }
      finally
      {
         unlock();
      }
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable
    *
    * @see Authenticatable#authenticate()
    */
   public void authenticate
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (ERROR_ON_DEPRECATED)
         {
            System.out.println("This API has been deprecated..." +
               "see documentation for more details. Stack trace follows:");
            Thread.dumpStack();
         }

         if (DEBUG)
         {
            Debug.println("SI.authenticate()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         this.getState().
            authenticate();
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
      }
      finally
      {
         unlock();
      }
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable
    *
    * @see Authenticatable#unauthenticate
    */
   public void unauthenticate
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (ERROR_ON_DEPRECATED)
         {
            System.out.println("This API has been deprecated..." +
               "see documentation for more details. Stack trace follows:");
            Thread.dumpStack();
         }

         if (DEBUG)
         {
            Debug.println("SI.unauthenticate()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         this.getState().
            unauthenticate();
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Authenticatable
    *
    * @see Authenticatable#isAuthenticated
    */
   public boolean isAuthenticated
   (
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.isAuthenticated()");
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }
         boolean auth = this.getState().
            isAuthenticated();
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }
         return auth;
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Authenticatable.
    */
   public Identity createIdentity
   (
      String userName
   )
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         if (DEBUG)
         {
            Debug.println("SI.createIdentity(): " + userName);
         }
         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(true);
         }

         Identity id = this.getState().
            createIdentity(userName);

         if (METHOD_TRACE_DEBUG)
         {
            Debug.traceMethods(false);
         }

         return id;
      }
      finally
      {
         unlock();
      }
   }

   public String toString()
   {
      lock();
      try
      {
         StringBuffer out = new StringBuffer();
         out.append("SessionImpl$:U=" + uid);
         try
         {
            out.append(":" + domainName);
         }
         catch (Exception e)
         {
            if (I_DEBUG)
            {
               Debug.ignoreException(e);
            }
         }
         finally
         {
            out.append(":" + state);
         }
         if (S_DEBUG)
         {
            Session s = this;
            while (s.hasParent())
            {
               Session p = s.getParent();
               if (s != p && p != null)
               {
                  s = p;
                  out.append(
                     ":PARENT=" + s.toString());
               }
               else
                  break;
            }
         }
         return out.toString();
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    */
   public Session findSession(String domainName)
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         return this.getState().findSession(domainName);
      }
      finally
      {
         unlock();
      }
   }

   /**
    * Inherited from Session
    */
   public Session findSessionTop(String domainName)
   throws SessionException
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      lock();
      try
      {
         return this.getState().findSessionTop(domainName);
      }
      finally
      {
         unlock();
      }
   }

   protected void lock()
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      if (null != parent)
         ((SessionImpl)parent).lock();
      else
      {
         synchronized (this)
         {
            try
            {
               while (tryLock() == false)
                  this.wait();
            }
            catch (InterruptedException e)
            {
               throw new SessionRuntimeException("Interrupted");
            }
         }
      }
   }

   private boolean tryLock()
   {
      if (owner == null)
      {
         owner = Thread.currentThread();
         lockCount = 1;
         if (LOCK_DEBUG)
            Debug.println("Acquired...");
         return (true);
      }

      if (owner == Thread.currentThread())
      {
         ++lockCount;
         return (true);
      }

      return (false);
   }

   protected void unlock()
   {
      if (DEBUG || ENTRY_DEBUG)
         Debug.println("Entry: " + this.domainName);
      if (null != parent)
         ((SessionImpl)parent).unlock();
      else
      {
         synchronized (this)
         {
            if (owner != Thread.currentThread())
               throw new SessionRuntimeException("Not current lock owner");

            if (--lockCount <= 0)
            {
               owner = null;
               if (LOCK_DEBUG)
                  Debug.println("Released...");
               notify();
//               Thread.yield();
            }
         }
      }
   }
}

