/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/toolkit/jcl/NWBoolean.java $
  $Revision: 1 $
  $Modtime: 3/05/98 2:47p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.toolkit.jcl;

/**
 * Provides a changeable boolean value that can be passed by
 * reference.
 *
 * <p>NWBoolean helps avoid the problem with Java boolean types
 * being passed by value, and Java boolean objects not having a set
 * function.
 *
 * <p>The intended use for NWBoolean is passing it to a native
 * routine that will set the value. The value can then be retrieved
 * and stored in a int base type value.
 * </p>
 */

/*
 * Public Method List (in order of their apperance in the file).
 *
 * CTD   Method name - Description
 * ---   --------------------------------------------------------------------
 * c d   NWBoolean - Constructor that takes an int for the new value.
 * c d   getValue - Retrieves the current value as an integer.
 * c d   setValue - Sets/overwrites the current value using a boolean.
 *
 */

public final class NWBoolean
{
   private boolean _value;


   /**
    * Constructs an NWBoolean with a value of zero.
    * </p>
    *
    * @return                    An NWBoolean set to zero.
    */
   public NWBoolean ()
   {
      _value = false;
   }

   /**
    * Constructs an NWBoolean with a specified value.
    * </p>
    *
    * @param <i>i</i>            (in) Initial value.
    *
    * @return                    An NWBoolean set to the value of <i>i</i>.
    */
   public NWBoolean (boolean value)
   {
      _value = value;
   }

   /**
    * Retruns the current value as an int.
    * </p>
    *
    * @return                    The current value as an int.
    */
   public boolean getValue ()
   {
      return (_value);
   }

   /**
    * Sets the current value using an int.
    * </p>
    *
    * @param <i>i</i>            (in) New value.
    */
   public void setValue (int i)
   {
      _value = (0==i ? false : true);
   }

   public void setValue (boolean b)
   {
      _value = b;
   }


}


