/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/toolkit/jcl/NetwareOSName.java $
  $Revision: 1 $
  $Modtime: 3/05/98 2:48p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.toolkit.jcl;

/**
 * NetwareOSName.
 * 
 * <p>This class supplies a static method that determines is the code is 
 * being executed on a netware server.
 * </p>
 */

public class NetwareOSName
{
   /**
    * Checks to see if the platform is Netware.
    *
    * <p>This static method uses the system propteries to determine if this
    * code is running on a netware platform.
    * </p>
    *
    * @return                    True if the platform is netware, false if
    *                            if is not.
    */
   public static boolean isNetware()
   {
      String osName = System.getProperty ("os.name");
      osName.toLowerCase();
      int offset = osName.indexOf("netware");
      if (offset == -1)
         return(false);
      return(true);
   }
}   