/* ***************************************************************************

  $Archive: /njcl_sample/NCP/SendNCPExtReq.java $
  $Revision: 1 $
  $Modtime: 11/19/98 11:52a $
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.

*****************************************************************************/

import java.util.Hashtable;
import java.io.ByteArrayOutputStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;
import com.novell.utility.naming.Environment;
import com.novell.service.ncpext.NCPExtension;
import com.novell.service.ncpext.NCPExtensionInfo;
import com.novell.service.ncpext.NCPExtensionStrings;

/**
 * Finds a server and an NCP extension handler which it exchanges requests.
 */

public class SendNCPExtReq
{
   static byte reply [];
   
   /**
    * This sample demonstrates working with an NCP extension.
    *
    * Once the NCP extension is found, the extension information is
    * displayed. Then a couple of messages are exchanged to verify
    * that we can talk correctly to the server.
    *
    * @param   argv              The command line which specifies the server
    *                            name and NCP extension name.
    *             argv[0]        Server name (e.g. MYSERVER)
    */
   public static void main (String argv[])
   {
      if (argv.length < 1)
      {
         System.out.println ("Error: missing parameters");
         System.out.println ("Usage: java SendNCPExtReq <servername>");
         System.exit (1);
      }
      
      try
      {
         byte[] request = new byte [1];
         String serverName = argv[0];
         String ncpextName = "ECHO_SERVER";
         
         // First get an initial context (the NetWare initial context)
         Hashtable hash = new Hashtable ();
         hash.put (
               Context.INITIAL_CONTEXT_FACTORY,
               Environment.NW_INITIAL_CONTEXT_FACTORY);
         Context initCtx = new InitialContext (hash);

         // Now lookup the server and NCP extension the user passed to us
         //  narrowing it to what we want
         NCPExtension ncpext = (NCPExtension) initCtx.lookup (
               "Servers/" + serverName + "/NCPExtensions/" + ncpextName);

         // Now we need to get the attribute list from which we get a single
         //  attribute from which we get a single attribute value
         DirContext ctx = (DirContext) ncpext;
         Attributes attrs = ctx.getAttributes ("");
         Attribute attr = attrs.get (
                              NCPExtensionStrings.NCPEXTENSION_ATTRIBUTE_ID);
         NCPExtensionInfo info = (NCPExtensionInfo) attr.get ();
         
         // Now lets display what we got for the user to verify we're OK
         System.out.println ("Name: " + info.getExtensionName ());
         System.out.println (
               "ID  : " +
               Integer.toHexString (info.getExtensionID ()));
         System.out.println (
               "Ver : " +
               String.valueOf (info.getMajorVersion ()) + 
               "." + 
               String.valueOf (info.getMinorVersion ()));
         System.out.println ("Rev : " + 
               String.valueOf (info.getRevision()));
               
         // We've got what we want so now send a couple of requests
         EndianOutputStream endianOut;
         ByteArrayOutputStream byteOut;
         EndianInputStream in;
         byteOut = new ByteArrayOutputStream ();
         endianOut = new EndianOutputStream (byteOut);
         endianOut.writeLoHiInt (1);      // 1 = LONG (32-bit int)
         endianOut.writeLoHiInt (1234);   // Just an int to show endian stuff
         reply = ncpext.send (byteOut.toByteArray (), 4);
         in = new EndianInputStream (reply);
         System.out.println ("Server received " + in.readLoHiInt () +
                              " (should be 8) bytes");
         byteOut = new ByteArrayOutputStream ();
         endianOut = new EndianOutputStream (byteOut);
         endianOut.writeLoHiInt (2);      // 2 = String (ASCIIZ)
         byteOut.write ((new String ("Hello")).getBytes ());
         reply = ncpext.send (byteOut.toByteArray (), 4);
         in = new EndianInputStream (reply);
         System.out.println ("Server received " + in.readLoHiInt () +
                             " (should be 9) bytes");
         
      } catch (Exception e)
      {
         System.out.println ("Exception occured: " + e);
         e.printStackTrace ();
      }
   } /* main () */

} /* class SendNCPExtReq */
