/****************************************************************************
  $Archive: /njcl_sample/NJCLApplet/src/SearchFrame.java $
  $Revision: 2 $
  $Modtime: 3/18/99 3:35p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
 ***************************************************************************/

import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * This class provides a graphical input dialog for retrieving the search
 * string.
 */

public class SearchFrame
   extends JDialog
   implements ActionListener
{
   private static int buttonHeight = 25;
   private static int buttonWidth = 100;
   private static int mainPaneHeight = 100;
   private static int mainPaneWidth = 400;

   // Declare controls
   JButton     okButton;
   JButton     cancelButton;
   JLabel      searchLabel;
   JTextField  searchTextField;

   String searchText;         // May be null or empty

   /**
    * Constructs the GUI portion of the search frame.
    */
   public SearchFrame (
         JFrame frame)
   {
      super (frame, "Search", true);
      GridBagLayout gbLayout = new GridBagLayout ();
      getContentPane ().setLayout (gbLayout);
      setSize (mainPaneWidth, mainPaneHeight);
      
      // Search label and field
      searchLabel = new JLabel ("Search string");
      searchLabel.setSize (buttonWidth, buttonHeight);
      Util.addGridBagComponent (getContentPane (), searchLabel, 0, 0, 1, 1, 0.0, 0.0);
      searchTextField = new JTextField ();
      searchTextField.setToolTipText ("'(Object class=user)' w/o quotes)");
      searchTextField.setSize (mainPaneWidth - buttonWidth, buttonHeight);
      Util.addGridBagComponent (getContentPane (), searchTextField, 1, 0, 1, 1, 0.0, 0.0);

      // Buttons
      JPanel buttonPanel = new JPanel (new FlowLayout (FlowLayout.CENTER));
      okButton = new JButton ("OK");
      okButton.setToolTipText ("Execute the search operation");
      okButton.addActionListener (this);
      okButton.setSize (buttonWidth, buttonHeight);
      buttonPanel.add (okButton);
      
      cancelButton  = new JButton ("Cancel");
      cancelButton.setToolTipText ("Cancel the search operation");
      cancelButton.addActionListener (this);
      cancelButton.setSize (buttonWidth, buttonHeight);
      buttonPanel.add (cancelButton);
      Util.addGridBagComponent (getContentPane (), buttonPanel, 0, 1, 2, 1, 0.5, 0.0);

      addWindowListener (new SearchWindowAdapter ());
   } // SearchFrame ()

   /**
    * Inner class for handling focus change and window close events.
    */
   class SearchWindowAdapter
      extends WindowAdapter
   {
      private boolean firstTime = true;
      
      public void windowActivated (WindowEvent event)
      {
         if (firstTime)
         {
            searchTextField.requestFocus ();
            firstTime = false;
         }
      }

      public void windowClosing (WindowEvent event)
      {
         searchText = null;
         setVisible (false);
      }
   } // class SearchWindowAdapter

   /**
    * ActionListener event handler method.
    */
   public void actionPerformed (
         ActionEvent event)
   {
      Object object = event.getSource ();
      if (object == okButton)
      {
         searchText = searchTextField.getText ();
         if (searchText.equals (""))
            searchText = null;
         setVisible (false);
      }
      else if (object == cancelButton)
      {
         searchText = null;
         setVisible (false);
      }
   } // ActionListener.actionPerformed ()

   /**
    * Return the text entered (or NULL if none or cancel).
    *
    * @return                    The search string entered. May be NULL.
    */
   public String getText ()
   {
      return (searchText);
   } // getText ()
   
} // class SearchFrame

