/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/NetwareFile.java $
  $Revision: 11 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import com.novell.java.io.NFile;
import com.novell.service.jncp.NSIException;

/**
 * Provides an interface for getting the NetWare file system file
 * object attribute values. 
 *
 * <p>The associated file object attribute values are the
 * following:
 * <ul><li>Directory Entry Information
 * <li>Extended Attributes
 * <li>Trustees</ul></p>
 */
public interface NetwareFile extends NFile
{
   /**
    * Returns the DirectoryEntryInformation object associated with
    * this file.
    * 
    * @return The DirectoryEntryInformation object.
    *
    * @exception NSIException when there is an error in getting the
    *                         DirectoryEntryInformation object.
    *
    * @see #setDirectoryEntryInformation
    * @see DirectoryEntryInformation
    */
   public DirectoryEntryInformation getDirectoryEntryInformation()
      throws NSIException;

   /**
    * Modifies the back end DirectoryEntryInformation object associated
    * with this directory entry.
    *
    * <p>The modifyMask parameter of the DirectoryEntryInformation
    * object is 0 by default. To modify individual parameters of the
    * DirectoryEntryInformation object, set bits in a modify mask and
    * pass this new mask in rather than the one obtained from the
    * getDirectoryEntryInformation() call.
    *
    * @param dei    The DirectoryEntryInformation modify value.
    * @param mod_op The modification to perform if the attribute is
    *               part of the set; valid values are
    *               DirContext.REPLACE_ATTRIBUTE.
    *
    * @exception NSIException when there is an error in setting the
    *                         DirectoryEntryInformation object.
    *
    * @see #getDirectoryEntryInformation
    * @see DirectoryEntryInformation
    */
   public void setDirectoryEntryInformation(
      DirectoryEntryInformation dei,
      int mod_op) 
      throws NSIException;

   /**
    * Returns the EAEnumerator object associated with this file.
    * 
    * @return The EAEnumerator object.
    *
    * @exception NSIException when there is an error in getting the
    *                         EAEnumerator object.
    */
   public EAEnumerator getEAEnumerator()
      throws NSIException;

   /**
    * Modifies the back end ExtendedAttribute object associated with
    * this directory entry.
    *
    * @param ea     The ExtendedAttribute modify value.
    * @param mod_op The modification to preform if the attribute is
    *               part of the set; valid values are
    *               DirContext.ADD_ATTRIBUTE and
    *               DirContext.REPLACE_ATTRIBUTE.
    *
    * @exception NSIException when there is an error in setting the
    *                         ExtendedAttribute object.
    */
   public void setExtendedAttribute(
      ExtendedAttribute ea,
      int mod_op) 
      throws NSIException;

   /**
    * Returns the TrusteeEnumerator object associated with this file.
    * 
    * @return  The TrusteeEnumerator object.
    *
    * @exception NSIException when there is an error in getting the
    *                         TrusteeEnumerator object.
    */
   public TrusteeEnumerator getTrusteeEnumerator()
      throws NSIException;

   /**
    * Modifies the back end Trustee Attribute object associated with 
    * this directory entry.
    *
    * @param trustee The Trustee Attribute modify value.
    * @param mod_op  The modification to perform if the attribute
    *                is part of the set; valid values are
    *                DirContext.ADD_ATTRIBUTE,
    *                DirContext.REMOVE_ATTRIBUTE, and
    *                DirContext.REPLACE_ATTRIBUTE.
    *
    * @exception NSIException when there is an error in setting the
    *                         Trustee object.
    */
   public void setTrustee(
      Trustee trustee,
      int mod_op) 
      throws NSIException;

   /**
    * Returns the EffectiveRights object associated with this file.
    * 
    * @return  The EffectiveRights object.
    *
    * @exception NSIException when there is an error in getting the
    *                         EffectiveRights object.
    */
   public EffectiveRights getEffectiveRights()
      throws NSIException;

}
