/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/naming/FSSchema.java $
  $Revision: 4 $
  $Modtime: 1/19/00 12:17p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw.naming;

/**
 * FSSchema defines the File System specific constants for the JNDI schema
 * assocaited with the file system.
 */
 
public class FSSchema
{
   /**
    * Name of the Class Definitions node bound to the Schema root.
    *
    * <p>(CLASS_DEFINITIONS = "Class Definitions")
    * </p>
    */
   public static final String CLASS_DEFINITIONS = "Classes";

   /**
    * Name of the Attribute Definitions node bound to the Schema root.
    * 
    *
    * <p>(ATTRIBUTE_DEFINITIONS = "Attribute Definitions")
    * </p>
    */
   public static final String ATTRIBUTE_DEFINITIONS = "Attributes";

   /**
    * Name of the Syntax Definitions node bound to the Schema root.
    *
    * <p>(SYNTAX_DEFINITIONS =  "Syntax Definitions")
    * </p>
    */
   public static final String SYNTAX_DEFINITIONS = "Syntaxes";

   /**
    * The Schema Attribute ID for the Class Definitions objects that will 
    * return a list of the attribute IDs of the mandatory attributes
    * associated with the class.
    *
    * <p>(MANDATORY_ATTRIBUTE_IDS = "Mandatory Attribute IDs")
    * </p>
    */
   public static final String MANDATORY_ATTRIBUTE_IDS = "Mandatory Attribute IDs";

   /**
    * The Schema Attribute ID for the Class Definitions objects that will 
    * return a list of the attribute IDs of the optional attributes 
    * associated with the class.
    *
    * <p>(OPTIONAL_ATTRIBUTE_IDS = "Optional Attribute IDs")
    * </p>
    */
   public static final String OPTIONAL_ATTRIBUTE_IDS = "Optional Attribute IDs";

   /**
    * The Schema Attribute ID for the Class Definitions and Attribute 
    * Definitions objects that will return a list of the interfaces that the  
    * associated class or attribute implements.
    *
    * <p>(INTERFACES_IMPLEMENTED = "Implements")
    * </p>
    */

   public static final String INTERFACES_IMPLEMENTED = "Implements";

   /**
    * The Schema Attribute ID for the Attribute Definitions objects that will 
    * return the type of the associated attributes object.
    *
    * <p>(ATTRIBUTE_TYPE =  "Type")
    * </p>
    */
   public static final String ATTRIBUTE_TYPE = "Type";

   /**
    * The Schema Attribute ID for the Attribute Definitions objects that will 
    * return the binding name of the associated attributes syntax object 
    * under the Syntax Defintions node of the schema tree. 
    *
    * <p>(SYNTAX_ID =  "Syntax Attribute ID")
    * </p>
    */
   public static final String SYNTAX_ID = "Syntax Attribute ID";

   /**
    * The binding name of the class definition DirContext associated with
    * the file systems initial context.
    * <p>(INITIAL_CONTEXT = "Initial Context Definitions")
    * </p>
    */
	public static final String INITIAL_CONTEXT = "Initial Context Definitions";

   /**
    * The binding name of the class definition DirContext associated with
    * the file systems volume contexts.
    * <p>(VOLUME_CONTEXT = "Volume Definitions")
    * </p>
    */
	public static final String VOLUME_CONTEXT = "Volume Definitions";

   /**
    * The binding name of the class definition DirContext associated with
    * the file systems Directory contexts.
    * <p>(DIRECTORY_CONTEXT = "Directory Definitions")
    * </p>
    */
	public static final String DIRECTORY_CONTEXT = "Directory Definitions";

   /**
    * The binding name of the class definition DirContext associated with
    * the file systems File contexts.
    * <p>(FILE_CONTEXT = "File Definitions")
    * </p>
    */
	public static final String FILE_CONTEXT = "File Definitions";

   /**
    * The Attribute ID of the Syntax Definitions Schema DirContext used to
    * optain the valid compare strings for a given attribute value.
    * <p>()
    * </p>
    */
	public static final String COMPARE = "compares";
}   
