/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include "jncpWire.h"

#include "NetAttrRecordJNI.h"


/* public final class NetAttrRecord implements Serializable
 * {
 *    //
 *    private int syntaxId;
 *    private String name;
 *    private NetAttributeValue[] values;
 * }
 */

#ifdef __cplusplus
extern "C" {
#endif


/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetAttrRecord)
NetAttrRecordCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetAttrRecord;
   jclass clsNetAttributeValue;
   //NJCL variables
   pNetAttrRecord sNetAttrRecord;

   sNetAttrRecord = (pNetAttrRecord) sysMalloc (sizeof (NetAttrRecord));

   if (NULL != sNetAttrRecord)
   {
      {
         //JNI variables
         jclass clsNetAttrRecordLR;

         clsNetAttrRecordLR = (*env)->FindClass (env, NETPKG "NetAttrRecord");
         clsNetAttrRecord = (*env)->NewGlobalRef (env, clsNetAttrRecordLR);
         (*env)->DeleteLocalRef (env, clsNetAttrRecordLR);

         // assign jclass variables
         sNetAttrRecord->cls = clsNetAttrRecord;
      }

      {
         //JNI variables
         jclass clsNetAttributeValueLR;

         clsNetAttributeValueLR = (*env)->FindClass (env, NETSYNTAXPKG "NetAttributeValue");
         clsNetAttributeValue = (*env)->NewGlobalRef (env, clsNetAttributeValueLR);
         (*env)->DeleteLocalRef (env, clsNetAttributeValueLR);

         // assign jclass variables
         sNetAttrRecord->clsNetAttributeValue = clsNetAttributeValue;
      }

      sNetAttrRecord->sNetAttributeValueFactory = NetAttributeValueFactoryCreateStruct (env);

      // assign jfieldID variables
      sNetAttrRecord->ID.name = (*env)->GetFieldID (env, clsNetAttrRecord, "name", "Ljava/lang/String;");
      sNetAttrRecord->ID.syntaxId = (*env)->GetFieldID (env, clsNetAttrRecord, "syntaxId", "I");
      sNetAttrRecord->ID.values = (*env)->GetFieldID (env, clsNetAttrRecord, "values", "[Lcom/novell/service/nds/net/NetAttributeValue;");
   }
   return (sNetAttrRecord);

} /* NetAttrRecordCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetAttrRecordCreate
(
   JNIEnv *env,
   pNetAttrRecord sNetAttrRecord,
   nuint32 infoType,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;
   nuint32 syntaxId;

   jobject attrRecord = (*env)->AllocObject (env, sNetAttrRecord->cls);

   switch (infoType)
   {
      case DS_ATTRIBUTE_NAMES:
      {
         {
            jstring name;

            NAlign32 (curPos);
            (*env)->SetObjectField (
                                       env,
                                       attrRecord,
                                       sNetAttrRecord->ID.name,
                              (jobject)(name = jncpGetString (env, curPos, limit)));
            (*env)->DeleteLocalRef (env, name);
         }

         break;
      }

      case DS_ATTRIBUTE_VALUES:
      {
         {
            NAlign32 (curPos);
            (*env)->SetIntField (
                                    env,
                                    attrRecord,
                                    sNetAttrRecord->ID.syntaxId,
                              (jint)(syntaxId = jncpGetInt32 (env, curPos, limit)));
         }

         {
            jstring name;

            (*env)->SetObjectField (
                                       env,
                                       attrRecord,
                                       sNetAttrRecord->ID.name,
                              (jobject)(name = jncpGetString (
                                                                  env,
                                                                  curPos,
                                                                  limit)));
            (*env)->DeleteLocalRef (env, name);
         }

         {
            // JNI variables
            jobjectArray values = NULL;
            // NWNet variables
            nuint32 i, count;

            NAlign32 (curPos);
            count = jncpGetInt32 (env, curPos, limit);

            values = (*env)->NewObjectArray (env, count, sNetAttrRecord->clsNetAttributeValue, NULL);

            for (i = 0; i < count; i++)
            {
               jobject value;

               NAlign32 (curPos);
               value = NetAttributeValueFactoryCreateAttributeValue (env, sNetAttrRecord->sNetAttributeValueFactory, buf, syntaxId);

               (*env)->SetObjectArrayElement (env, values, (jsize) i, value);
               (*env)->DeleteLocalRef (env, value);
            }
            (*env)->SetObjectField (env, attrRecord, sNetAttrRecord->ID.values, values);
            (*env)->DeleteLocalRef (env, values);
         }

         break;
      }

      default:
      {
         break;
      }
   }

   return (attrRecord);

} /* NetAttrRecordCreate () */


#ifdef __cplusplus
}
#endif


