/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include "jncpWire.h"

#include "NetCounterJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetCounter
 *    extends NdsCounter
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected boolean value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetCounter)
NetCounterCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetCounter;
   jclass clsNetCounterLR;
   //NJCL variables
   pNetCounter sNetCounter;

   clsNetCounterLR = (*env)->FindClass (env, NETSYNTAXPKG "NetCounter");
   clsNetCounter = (*env)->NewGlobalRef (env, clsNetCounterLR);
   (*env)->DeleteLocalRef (env, clsNetCounterLR);

   sNetCounter = (pNetCounter) sysMalloc (sizeof (NetCounter));

   if (NULL != sNetCounter)
   {
      // assign jclass variables
      sNetCounter->cls = clsNetCounter;

      // assign jfieldID variables
      sNetCounter->ID.value = (*env)->GetFieldID (env, clsNetCounter, "value", "I");
   }
   return (sNetCounter);

} /* NetCounterCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetCounterCreate
(
   JNIEnv *env,
   pNetCounter sNetCounter,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netCounter = (*env)->AllocObject (env, sNetCounter->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netCounter,
                              sNetCounter->ID.value,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }
   return (netCounter);

} /* NetCounterCreate () */


#ifdef __cplusplus
}
#endif


