
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/NetEntryInfo.java $
  $Revision: 11 $
  $Modtime: 6/02/00 4:09p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.net;


import java.io.Serializable;
import java.io.IOException;

import com.novell.java.io.EndianInputStream;

import com.novell.service.jncp.NSIException;

//import com.novell.service.jncpv2.net.NetJNI;

import com.novell.service.nds.NdsObjectInfo;


/** @internal
 *
 */
public final class NetEntryInfo implements NdsObjectInfo, Serializable
{
   private int outputFlags;
   private int entryId;
   private int entryFlags;
   private int subordinateCount;
   private int modificationTime;
   private int modificationTimestamp;
   private int creationTimestamp;
   private int partitionRootId;
   private int parentId;
   private int revisionCount;
   private int replicaType;
   private String baseClass;
   private String entryRDN;
   private String entryDN;
   private String partitionRootDN;
   private String parentDN;
   private int purgeTime;
   private String dereferenceBaseClass;
   private int replicaNumber;
   private int replicaState;
	private String federationBoundary;
	private String schemaBoundary;

   private boolean dereference;


   /**
    *    @deprecated
    */
   public NetEntryInfo (
         EndianInputStream eis)
      throws NSIException
   {
      this (eis, false);
   }

   /**
    *    @deprecated
    */
   public NetEntryInfo (
         EndianInputStream eis,
         boolean dereference)
      throws NSIException
   {
      this.dereference = dereference;

      try
      {
         eis.align32 ();

         /* DSI_OUTPUT_FIELDS */
         outputFlags = eis.readLoHiInt ();

         /* DSI_ENTRY_ID */
         if ((outputFlags & NetJNI.DSI_ENTRY_ID) != 0)
         {
            entryId = eis.readLoHiInt ();
         }

         /* DSI_ENTRY_FLAGS */
         if ((outputFlags & NetJNI.DSI_ENTRY_FLAGS) != 0)
         {
            entryFlags = eis.readLoHiInt ();
         }

         /* DSI_SUBORDINATE_COUNT */
         if ((outputFlags & NetJNI.DSI_SUBORDINATE_COUNT) != 0)
         {
            subordinateCount = eis.readLoHiInt ();
         }

         /* DSI_MODIFICATION_TIME */
         if ((outputFlags & NetJNI.DSI_MODIFICATION_TIME) != 0)
         {
            modificationTime = eis.readLoHiInt ();
         }

         /* DSI_MODIFICATION_TIMESTAMP */
         if ((outputFlags & NetJNI.DSI_MODIFICATION_TIMESTAMP) != 0)
         {
//   private int modificationTimestamp;
            eis.readLoHiInt ();
            eis.readLoHiShort ();
            eis.readLoHiShort ();
         }

         /* DSI_CREATION_TIMESTAMP */
         if ((outputFlags & NetJNI.DSI_CREATION_TIMESTAMP) != 0)
         {
//      private int creationTimestamp;
            eis.readLoHiInt ();
            eis.readLoHiShort ();
            eis.readLoHiShort ();
         }

         /* DSI_PARTITION_ROOT_ID */
         if ((outputFlags & NetJNI.DSI_PARTITION_ROOT_ID) != 0)
         {
            partitionRootId = eis.readLoHiInt ();
         }

         /* DSI_PARENT_ID */
         if ((outputFlags & NetJNI.DSI_PARENT_ID) != 0)
         {
            parentId = eis.readLoHiInt ();
         }

         /* DSI_REVISION_COUNT */
         if ((outputFlags & NetJNI.DSI_REVISION_COUNT) != 0)
         {
            revisionCount = eis.readLoHiInt ();
         }

         /* DSI_REPLICA_TYPE */
         if ((outputFlags & NetJNI.DSI_REPLICA_TYPE) != 0)
         {
            replicaType = eis.readLoHiInt ();
         }

         /* DSI_BASE_CLASS */
         if ((outputFlags & NetJNI.DSI_BASE_CLASS) != 0)
         {
            eis.readLoHiInt ();
            baseClass = eis.readLoHiChars ();
         }

         /* DSI_ENTRY_RDN */
         if ((outputFlags & NetJNI.DSI_ENTRY_RDN) != 0)
         {
            eis.align32 ();
            eis.readLoHiInt ();
            entryRDN = eis.readLoHiChars ();
         }

         /* DSI_ENTRY_DN */
         if ((outputFlags & NetJNI.DSI_ENTRY_DN) != 0)
         {
            eis.align32 ();
            eis.readLoHiInt ();
            entryDN = eis.readLoHiChars ();
         }

         /* DSI_PARTITION_ROOT_DN */
         if ((outputFlags & NetJNI.DSI_PARTITION_ROOT_DN) != 0)
         {
            eis.align32 ();
            eis.readLoHiInt ();
            partitionRootDN = eis.readLoHiChars ();
         }

         /* DSI_PARENT_DN */
         if ((outputFlags & NetJNI.DSI_PARENT_DN) != 0)
         {
            eis.align32 ();
            eis.readLoHiInt ();
            parentDN = eis.readLoHiChars ();
         }

         /* DSI_PURGE_TIME */
         if ((outputFlags & NetJNI.DSI_PURGE_TIME) != 0)
         {
            eis.align32 ();
            purgeTime = eis.readLoHiInt ();
         }

         /* DSI_DEREFERENCE_BASE_CLASS */
         if ((outputFlags & NetJNI.DSI_DEREFERENCE_BASE_CLASS) != 0)
         {
            eis.align32 ();
            eis.readLoHiInt ();
            dereferenceBaseClass = eis.readLoHiChars ();
         }

         /* DSI_REPLICA_NUMBER */
         if ((outputFlags & NetJNI.DSI_REPLICA_NUMBER) != 0)
         {
            eis.align32 ();
            replicaNumber = eis.readLoHiInt ();
         }

         /* DSI_REPLICA_STATE */
         if ((outputFlags & NetJNI.DSI_REPLICA_STATE) != 0)
         {
            replicaState = eis.readLoHiInt ();
         }

         /* DSI_FEDERATION_BOUNDARY */
         if ((outputFlags & NetJNI.DSI_FEDERATION_BOUNDARY) != 0)
         {
            eis.align32 ();
            eis.readLoHiInt ();
            federationBoundary = eis.readLoHiChars ();
         }

         /* DSI_SCHEMA_BOUNDARY */
         if ((outputFlags & NetJNI.DSI_SCHEMA_BOUNDARY) != 0)
         {
            eis.align32 ();
            eis.readLoHiInt ();
            schemaBoundary = eis.readLoHiChars ();
         }
      }
      catch (IOException e)
      {
         throw (new NSIException ());
      }

   } /* NetEntryInfo () */

   /**
    *
    */
   public int getOutputFlags ()
   {
      return (outputFlags);
   }

   /**
    *
    */
   public int getEntryId ()
   {
      return (entryId);
   }

   /**
    *
    */
   public int getEntryFlags ()
   {
      return (entryFlags);
   }

   /**
    *
    */
   public int getSubordinateCount ()
   {
      return (subordinateCount);
   }

   /**
    *
    */
   public int getModificationTime ()
   {
      return (modificationTime);
   }

   /**
    *
    *
   public NdsTimestamp getModificationTimestamp ()
   {
      return (modificationTimestamp);

   } *  */

   /**
    *
    *
   public NdsTimestamp getCreationTimestamp ()
   {
      return (creationTimestamp);

   } *  */

   /**
    *
    */
   public int getPartitionRootId ()
   {
      return (partitionRootId);
   }

   /**
    *
    */
   public int getParentId ()
   {
      return (parentId);
   }

   /**
    *
    */
   public int getRevisionCount ()
   {
      return (revisionCount);
   }

   /**
    *
    */
   public int getReplicaType ()
   {
      return (replicaType);
   }

   /**
    *
    */
   public String getBaseClass ()
   {
      return (dereference ? dereferenceBaseClass : baseClass);
   }

   /**
    *
    */
   public String getEntryRDN ()
   {
      return (entryRDN);
   }

   /**
    *
    */
   public String getEntryDN ()
   {
      return (entryDN);
   }

   /**
    *
    */
   public String getPartitionRootDN ()
   {
      return (partitionRootDN);
   }

   /**
    *
    */
   public String getParentDN ()
   {
      return (parentDN);
   }

   /**
    *
    */
   public int getPurgeTime ()
   {
      return (purgeTime);
   }

   /**
    *
    */
   public String getDereferenceBaseClass ()
   {
      return (dereferenceBaseClass);
   }

   /**
    *
    */
   public int getReplicaNumber ()
   {
      return (replicaNumber);
   }

   /**
    *
    */
   public int getReplicaState ()
   {
      return (replicaState);
   }


   /**
    *
    */
   public int getObjectFlags ()
   {
      return (entryFlags);
   }

   /**
    *
    */
   public String getFederationBoundary ()
   {
      return (federationBoundary);
   }

   /**
    *
    */
   public String getSchemaBoundary ()
   {
      return (schemaBoundary);
   }

	/**
	 * This method should never be called from a NetEntryInfo implementation
	 * of NdsObjectInfo. (Only from NetObjectInfo)
	 */
	public boolean isManagementRoot ()
	{
		return false;
	}

} /* NetEntryInfo */


