
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/NdsInterval.java $
  $Revision: 10 $
  $Modtime: 10/15/99 2:07p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.io.Serializable;

import com.novell.service.schema.SchemaNumber;


/**
 * Provides access to values of the Interval attribute.
 * It is used for attributes whose values represent an interval
 * of time in number of seconds. Attributes using this syntax
 * can set size limits. The attributes for two intervals match
 * for equality if they are the same. The comparison for
 * ordering uses signed integer rules.
 * 
 * <p>Matching Rules: Equality and Ordering</p>
 *
 * @see NdsSyntaxId
 */
public class NdsInterval 
   implements NdsAttributeValue, SchemaNumber, Cloneable, Serializable
{
   private static final int matchingRules = equality|ordering;

  /**
   * @internal
   */
   protected int value;

   private String name;


  /**
   * Constructs an NdsInterval object based on the specified
   * value parameter.
   *
   * @param value The time interval in seconds to be stored as a
   *              Long value.
   */
   public NdsInterval (
         long value)
   {
      this ("", value);
   }

  /**
   * @internal
   */
   protected NdsInterval ()
   {
      this.value = -1;
      this.name = null;
   }

  /*
   * Private constructor; not documented. 
   */
   private NdsInterval (
         String name,
         long value)
   {
      this.value = (int) (value & INT_MASK);
      this.name = name;
   }

  /**
   * @internal
   */
   protected NdsInterval (
         NdsInterval anInterval)
   {
      this.value = anInterval.value;
      this.name = anInterval.name;
   }


   // ******************** SchemaValue Interface ********************

  /**
   * Compares two objects for ordering, or compares two strings
   * lexicographically. For the Interval syntax, the compareTo
   * method compares this NDS Object with a reference NDS Object
   * contained in the anObject parameter. The comparison is done
   * according to the Ordering matching rule for this syntax.
   * 
   * @param anObject The reference NDS Object with which
   *                 to compare.
   *
   * @return An int set to 0 if the reference Object is equal
   *         to this Object; an int <0 if the reference Object
   *         is less than this Object; an int >0 if the reference
   *         Object is greater than this Object.
   *
   * @exception IllegalArgumentException The passed-in object is of
   *            a different type than this NDS Object.
   */
   public int compareTo (
         Object anObject)
      throws Exception
   {
      if (anObject instanceof NdsInterval)
      {
         int value;

         value = ((NdsInterval) anObject).intValue ();
         return (this.value > value ? 1 : this.value < value ? -1 : 0);
      }
      throw (new IllegalArgumentException ());
   }

  /**
   * Compares two Objects for equality. The equals method compares
   * this object value with the value of the reference object in
   * the anObject parameter.
   *
   * <p>The equals method implements the most discriminating possible
   * equivalence relation on objects; that is, for any reference values
   * X and Y, this method returns TRUE if and only if X and Y refer to
   * the same object (X==Y has the value TRUE).</p>
   * 
   * @param anObject The reference object with which to compare.
   *
   * @return A boolean set to TRUE if and only if the argument is not
   *         NULL and is an NDS integer object that contains the
   *         same value as this object, otherwise set to FALSE.
   */
   public boolean equals (
         Object anObject)
   {
      if ((anObject != null) && (anObject instanceof NdsInterval))
      {
         return (value == ((NdsInterval) anObject).intValue ());
      }
      return (false);
   }

  /**
   * @internal
   */
   public String getName ()
   {
      return (name);
   }

  /**
   * @internal
   */
   public String getSyntaxId ()
   {
      return (NdsSyntaxId.INTERVAL);
   }


   // ******************** SchemaNumber Interface ********************

   /**
    * Returns the value of this NDS object as an int.
    * 
    * @return The int value of this NDS object.
    */
   public int intValue ()
   {
      return (value);
   }

   /**
    * Returns the value of this NDS object as a long.
    * 
    * @return The long value of this NDS object.
    */
   public long longValue ()
   {
      return ((long) value);
   }

   /**
    * Returns the value of this NDS object as a float.
    * 
    * @return The float value of this NDS object.
    */
   public float floatValue ()
   {
      return ((float) value);
   }

   /**
    * Returns the value of this NDS object as a double.
    * 
    * @return The double value of this NDS object.
    */
   public double doubleValue ()
   {
      return ((double) value);
   }

   /**
    * Returns the value of this NDS object as a byte.
    * 
    * @return The byte value of this NDS object.
    */
   public byte byteValue ()
   {
      return ((byte) value);
   }

   /**
    * Returns the value of this NDS object as a short.
    * 
    * @return The short value of this NDS object.
    */
   public short shortValue ()
   {
      return ((short) value);
   }


   // ******************** NdsAttributeValue Interface ********************

  /**
   * Compares two Objects using the approximate matching rule.
   * 
   * The approximate method does not apply to the NdsInterval syntax
   * because this syntax does not support the approximate equals
   * matching rule.
   */
   public boolean approximate (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Returns the int that represents the NDS syntax ID.
   *
   * @return The syntax ID as an int.
   */
   public int getNdsSyntaxId ()
   {
      return (NdsSyntaxId.INTERVAL_ID);
   }

  /**
   * Checks to see if this object supports the specified
   * matching rules. The NdsInterval syntax supports the
   * Equality and Ordering matching rules.
   *
   * @param matchingRules The set of matching rules to check.
   *
   * @return A Boolean set to TRUE if the matching rules for this
   *         object are equal to the matchingRules parameter.
   */
   public boolean supportsMatchingRules (
         int matchingRules)
   {
      if ((matchingRules & this.matchingRules) == matchingRules)
         return (true);
      else
         return (false);
   }


   // ******************** Object Class ********************

  /**
   * Creates a new object of the same class as this object. It
   * then initializes each of the new object's fields by assigning
   * them the same value as the corresponding fields in this object.
   * No constructor is called.
   *
   * @return A clone of this object instance containing the cloned
   *         syntax.
   */
   public Object clone ()
   {
      try
      {
         NdsInterval interval = (NdsInterval) super.clone ();

         interval.value = this.value;

         interval.name = this.name;

         return (interval);
      }
      catch (CloneNotSupportedException e)
      {
         // this shouldn't happen, since we are Cloneable
         throw (new InternalError ());
      }

   } /* clone () */

  /**
   * Generates a string representation of the object. It
   * returns a string that textually represents the object.
   * The result should be a concise but informative
   * representation that is easy to read.
   *
   * @return The String representation of the object.
   */
   public String toString ()
   {
      return (String.valueOf (value));
   }


   // ******************** NdsInterval Class ********************

  /**
   * Returns the Interval stored as a long value in the NDS
   * attribute.
   *
   * @return The interval as a long value.
   */
   public long getInterval ()
   {
      return (value & INT_MASK);
   }

} /* NdsInterval */


