
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetEntryAttributeId.java $
  $Revision: 4 $
  $Modtime: 4/18/00 10:56a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.nds.naming.NdsObjectAttributeId;

import com.novell.service.jncpv2.net.NetJNI;


/** @internal
 *
 */
public class NetEntryAttributeId implements NdsObjectAttributeId
{
   private static Hashtable hashtable;


   static
   {
      hashtable = new Hashtable ();

      hashtable.put (
                    ENTRY_ID.toUpperCase (),
                    new Integer (NetJNI.DSI_ENTRY_ID));
      hashtable.put (
                    ENTRY_FLAGS.toUpperCase (),
                    new Integer (NetJNI.DSI_ENTRY_FLAGS));
      hashtable.put (
                    SUBORDINATE_COUNT.toUpperCase (),
                    new Integer (NetJNI.DSI_SUBORDINATE_COUNT));
      hashtable.put (
                    MODIFICATION_TIME.toUpperCase (),
                    new Integer (NetJNI.DSI_MODIFICATION_TIME));
      hashtable.put (
                    MODIFICATION_TIMESTAMP.toUpperCase (),
                    new Integer (NetJNI.DSI_MODIFICATION_TIMESTAMP));
      hashtable.put (
                    CREATION_TIMESTAMP.toUpperCase (),
                    new Integer (NetJNI.DSI_CREATION_TIMESTAMP));
      hashtable.put (
                    PARTITION_ROOT_ID.toUpperCase (),
                    new Integer (NetJNI.DSI_PARTITION_ROOT_ID));
      hashtable.put (
                    PARENT_ID.toUpperCase (),
                    new Integer (NetJNI.DSI_PARENT_ID));
      hashtable.put (
                    REVISION_COUNT.toUpperCase (),
                    new Integer (NetJNI.DSI_REVISION_COUNT));
      hashtable.put (
                    REPLICA_TYPE.toUpperCase (),
                    new Integer (NetJNI.DSI_REPLICA_TYPE));
      hashtable.put (
                    BASE_CLASS.toUpperCase (),
                    new Integer (NetJNI.DSI_BASE_CLASS));
      hashtable.put (
                    ENTRY_RDN.toUpperCase (),
                    new Integer (NetJNI.DSI_ENTRY_RDN));
      hashtable.put (
                    ENTRY_DN.toUpperCase (),
                    new Integer (NetJNI.DSI_ENTRY_DN));
      hashtable.put (
                    PARTITION_ROOT_DN.toUpperCase (),
                    new Integer (NetJNI.DSI_PARTITION_ROOT_DN));
      hashtable.put (
                    PARENT_DN.toUpperCase (),
                    new Integer (NetJNI.DSI_PARENT_DN));
      hashtable.put (
                    PURGE_TIME.toUpperCase (),
                    new Integer (NetJNI.DSI_PURGE_TIME));
      hashtable.put (
                    DEREFERENCE_BASE_CLASS.toUpperCase (),
                    new Integer (NetJNI.DSI_DEREFERENCE_BASE_CLASS));
      hashtable.put (
                    FEDERATION_BOUNDARY.toUpperCase (),
                    new Integer (NetJNI.DSI_FEDERATION_BOUNDARY));
      hashtable.put (
                    SCHEMA_BOUNDARY.toUpperCase (),
                    new Integer (NetJNI.DSI_SCHEMA_BOUNDARY));

   } /* static */


   /**
    *
    */
   public static Integer getEntryInfoFlag (
         String attributeId)
   {
      return ((Integer) hashtable.get (attributeId.toUpperCase ()));
   }

} /* NetEntryAttributeId */


