
/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/naming/net/NetReplicaInfo.java $
  $Revision: 1 $
  $Modtime: 3/02/98 2:27p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import com.novell.service.nds.NdsTimestamp;


/**
 *  NetReplicaInfo - partition info from a specific replica server.
 *
 *  Certain info returned from this class depends upon the Client
 *  version. If the Client is same as the one from SDK v13 or higher,
 *  all info in this class are valid. Otherwise, only replicaType,
 *  and partitionName are valid.
 */
public class NetReplicaInfo
{

    protected String serverName;
    protected String serverRead;

    protected int replicaType;
    protected int replicaState;

    protected String partitionName;
    protected boolean partitionBusy;

    protected NdsTimestamp modificationTime;

    /**
     *  Constructs a NdsReplicaInfo object which represents
     *  a replica stored on a server.
     *
     *  @param  serverName          FDN of the server.
     *  @param  serverRead          FDN of the server read.
     *  @param  replicaType         Replica type.
     *  @param  replicaState        Replica state.
     *  @param  partitionName       FDN of the partition.
     *  @param  partitionBusy       Partition busy status.
     *  @param  modificationTime    Replica's modification time.
     */
   protected NetReplicaInfo(
         String serverName,
         String serverRead,
         int replicaType,
         int replicaState,
         String partitionName,
         boolean partitionBusy,
         NdsTimestamp modificationTime)
    {
        this.serverName = serverName;
        this.serverRead = serverRead;

        this.replicaType = replicaType;
        this.replicaState = replicaState;

        this.partitionName = partitionName;
        this.partitionBusy = partitionBusy;

        this.modificationTime = modificationTime;
    }

    /**
     *  @return Server's FDN
     */
    public String getServerName() {
        return this.serverName;
    }

    /**
     *  @return Server Read's FDN
     */
    public String getServerRead() {
        return this.serverRead;
    }

    /**
     *  @return Replica's type
     */
    public int getReplicaType() {
        return this.replicaType;
    }

    /**
     *  @return Replica's state
     */
    public int getReplicaState() {
        return this.replicaState;
    }

    /**
     *  @return Partition's FDN
     */
    public String getPartitionName() {
        return this.partitionName;
    }

    /**
     *  @return Partition's busy status
     */
    public boolean getPartitionBusyStatus() {
        return this.partitionBusy;
    }

    /**
     *  @return Replica's modification time stamp
     */
    public NdsTimestamp getModificationTime() {
        return this.modificationTime;
    }

} /* NetReplicaInfo */


