
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/SearchObject.java $
  $Revision: 5 $
  $Modtime: 1/28/00 12:43p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.io.*;

import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.sun.jndi.toolkit.*;

import com.novell.service.jncp.*;
import com.novell.service.jncpv2.clx.ClxJNI;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;
import com.novell.service.nds.naming.NdsDirContextWrappable;
import com.novell.service.nds.net.*;
import com.novell.service.nds.ldap.LdapAttributeValueFactory;

import com.novell.service.session.SessionException;
import com.novell.service.jncpv2.net.*;

import com.novell.service.toolkit.jcl.NWInteger;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.directory.NAttributes;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/*
 * This class is used to accumulate attributes spread over multiple
 * iterations of an object returned by NWDSSearch() into one search object.
 */
class SearchObject
{
    private String objectName;
    private NetObjectInfo ndsObjectInfo = new NetObjectInfo ();
    private Vector attrIds = new Vector();
    private Attributes attrs;

    public SearchObject(NetBuffer objectInfo, NetEnvironment environment)
    throws NamingException
    {
        StringBuffer objectNameBuf = new StringBuffer ();
        NWInteger attributeCount = new NWInteger ();
		  int attrCnt;

        // get objects name, etc...
        objectInfo.getObjectName (
                     objectNameBuf,
                     attributeCount,
                     this.ndsObjectInfo);

        this.objectName = objectNameBuf.toString ();
		  attrCnt = attributeCount.getValue ();

/*
        attrs = new SNetAttributes (
                        objectName,
                        attributeCount.getValue (),
                        environment,
                        objectInfo);
*/
		  attrs = new BasicAttributes();
		  while (attrCnt-- > 0)
		  {
			  attrs.put ((Attribute) new NetAttribute (
				                          objectName,
												  environment,
												  objectInfo));
		  }

    } /* SearchObject () */

    /**
     *
     */
    public Attributes getAttributes()
    {
        return this.attrs;
    }

    /**
     * Will merge different attributes and the values of like attributes
     * into the same attribute set.
     */
    public void mergeAttributes(Attributes attrs)
    throws NamingException
    {
        NamingEnumeration attrsNe = attrs.getAll ();

        while (attrsNe.hasMoreElements ())
        {
            Attribute attr = (Attribute)attrsNe.next ();
            Attribute tAttr = this.attrs.get (attr.getID ());

            if (tAttr == null) // we have a new attribute
            {
                this.attrs.put (attr);
            }
            else // we have a matched attribute (merge the values)
            {
                NamingEnumeration attrNe = attr.getAll ();

                while (attrNe.hasMoreElements ())
                {
                    tAttr.add(attrNe.next ());
                }
            }
        }
    }


    /**
     *
     */
    protected boolean equalsApproximate (
          Object object)
    {
       if ((object != null) && (object instanceof SearchObject))
       {
          SearchObject target = (SearchObject) object;

          if (objectName.equals (target.getName ()))
          {
             return (true);
          }
       }
       return (false);

    } /* equalsApproximate ()  */

    /**
     *
     */
    public String getName()
    {
        return this.objectName;
    }

    /**
     *
     */
    public NetObjectInfo getNdsObjectInfo()
    {
        return this.ndsObjectInfo;
    }

} /* SearchObject */


// ******************** SNetAttributes ********************

/*
class SNetAttributes extends NAttributes
{
   protected SNetAttributes (
         String objectName,
         int attributeCount,
         NetEnvironment netEnvironment,
         NetBuffer objectInfo)
      throws NamingException
   {
      super (true);

      while (attributeCount-- > 0)
      {
         super.put ((Attribute) new NetAttribute (
                                    objectName,
                                    netEnvironment,
                                    objectInfo));
      }

   } // SNetAttributes ()

} // SNetAttributes
*/

