
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetReplicaPointer.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsNetAddress;
import com.novell.service.nds.NdsReplicaPointer;


/** @internal
 * NetReplicaPointer is an Adapter for NdsReplicaPointer.
 *
 * This class converts to/from the NWNet Replica_Pointer_T.
 * 
 * API Data Structure:
 *    typedef struct
 *    {
 *       pnchar            serverName;
 *       NWREPLICA_TYPE    replicaType;
 *       NWREPLICA_NUM     replicaNumber;
 *       NWCOUNT           count;
 *       Net_Address_T     replicaAddressHint[?];
 * 
 *    } Replica_Pointer_T;
 */
public final class NetReplicaPointer
   extends NdsReplicaPointer implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Replica Pointer from the "API Data Structure".
    * 
    * @param   value   byte[] containing a Replica_Pointer_T
    */
   protected NetReplicaPointer (
         byte[] value)
      throws NSIException
   {
      try
      {
         int count;
         EndianInputStream edis = new EndianInputStream (value);

         this.serverName = edis.readLoHiChars ();
         this.replicaType = edis.readLoHiInt ();
         this.replicaNumber = edis.readLoHiInt ();
         count = edis.readLoHiInt ();
         this.replicaAddressHint = new NdsNetAddress[count];
         for (int i = 0; i < count; i++)
         {
            int type = edis.readLoHiInt ();
            byte[] address = new byte [edis.readLoHiInt ()];

            edis.readFully (address);
            this.replicaAddressHint[i] = new NdsNetAddress (type, address);
         }
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetReplicaPointer adapter for an NdsReplicaPointer.
    * 
    * @param   value   an NdsReplicaPointer object.
    */
   protected NetReplicaPointer (
         NdsReplicaPointer value)
   {
      super (value);
   }

   /**
    * Returns a Replica Pointer "API Data Structure".
    * 
    * @return   byte[] containing Replica_Pointer_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         int count;
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.serverName);
         eos.writeLoHiInt (this.replicaType);
         eos.writeLoHiInt (this.replicaNumber);
         count = this.replicaAddressHint.length;
         eos.writeLoHiInt (count);
         for (int i = 0; i < count; i++)
         {
            eos.writeLoHiInt ((int) this.replicaAddressHint[i].getType ());
            eos.writeLoHiInt ((int) this.replicaAddressHint[i].getLength ());
            eos.write (this.replicaAddressHint[i].getAddress ());
         }
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetReplicaPointer */


