/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nw/BinderyServerNamesEnumerator.java $
  $Revision: 4 $
  $Modtime: 1/28/00 12:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nw;
import java.util.*;
import com.novell.service.jncp.*;
import com.novell.service.session.*;
import com.novell.service.session.xplat.CallsService;
import com.novell.service.session.xplat.Xplat;
import com.novell.java.lang.IntegerBuffer;

class BinderyServerNamesEnumerator implements Enumeration
{
   private CallsService service;
   private IntegerBuffer objID;
   private String serverName, oldServerName;
   private boolean more;

   /**
   * Performs a look-ahead scan of bindery sap table for server names
   */
   public BinderyServerNamesEnumerator(Hashtable h)
   {
      try
      {
         Session s = (Session)h.get(com.novell.utility.naming.Environment.SESSION_OBJECT);
         service = (CallsService)s.getService(CallsService.KEY);
         objID = new IntegerBuffer(0xFFFFFFFF);
         more = true;
         scanObject();
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }
   }

   public boolean hasMoreElements()
   {
      return more;
   }

   public Object nextElement()
   {
      if(!more)
         throw new NoSuchElementException();
      oldServerName = serverName;
      scanObject();
      return oldServerName;
   }

   private void scanObject()
   {
      try
      {
         StringBuffer name = new StringBuffer();
         service.scanObject(
            "*",
            Xplat.NW_SERVER_TYPE,
            objID,
            name,
            (IntegerBuffer)null,    // unused. objType
            (IntegerBuffer)null,    // unused. hasPropertiesFlag
            (IntegerBuffer)null,    // unused. objFlags
            (IntegerBuffer)null);   // unused. objSecurity
         serverName = name.toString();
      }
      catch(NSIException ne)
      {
         more=false; //Expecting an exception when no more elements
      }
      catch(Exception e)
      {
         more=false;
         throw NSIExceptionBuilder.build(e);
      }
   }
}
