/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/naming/QMSQueueAttribute.java $
  $Revision: 3 $
  $Modtime: 4/24/98 4:10p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;

import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.qms.*;

/** @internal
 *  public class QMSQueueAttribute
 *    extends Attribute
 */

public class QMSQueueAttribute extends BasicAttribute
{

   /*
    * Constructs a new instance of an attribute.
    *
    * @param queue      (in) the queue to get the attribute from
    * @param ID         (in) the ID of the attribute
    */
   public QMSQueueAttribute ( String id, QMSQueue queue )
      throws NamingException
   {
      super (id);

      if( id.equals( QMSStrings.QUEUE_ATTRID_STATE ) )
      {
         // Add this value to the attribute
         add( new Integer( queue.getState() ) );
      }
      else
         throw new InvalidAttributeIdentifierException();
   }
} /* QMSQueueAttribute */



