/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/security/NdsIdentityScope.java $
  $Revision: 7 $
  $Modtime: 11/24/98 7:44p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import com.novell.java.util.Debug;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.PublicKey;

/**
 * Represents an authenticatable container in NDS, such as a context,
 * or a tree. Every NdsIdentity is associated with an identity scope
 * that is typically an NDS context. The NDS context is, in turn,
 * associated with an NDS tree, which is associated with the NDS
 * administrative domain scope. The tree domain scope is a child of
 * the administrative  domain scope. The context domain scope is a
 * child of the tree domain scope. There may be many context domain
 * scopes. A user identity is a child of the context domain scope.
 *
 * <p>For example, to construct a user named Karah, in a subcontext called
 * Java, in a context called Engineering, and in an NDS tree called
 * KARAH_CORP you might do the following:
 * <code>
 * <pre>
 * IdentityScope administrativeDomain  = new NdsIdentityScope();
 * IdentityScope tree                  = new NdsIdentityScope("KARAH_CORP",administrativeDomain);
 * IdentityScope context               = new NdsIdentityScope("Engineering",tree);
 * IdentityScope subcontext            = new NdsIdentityScope("Java",context);
 * Identity      user                  = new NdsIdentity("Karah",subcontext);
 * </pre>
 * </code>
 *
 * @see com.novell.java.security.Identity
 * @see com.novell.java.security.IdentityScope
 * @see NdsIdentity
 * @see BinderyIdentity
 * @see BinderyIdentityScope
 *
 * @author Jan Sture Nielsen
 * @version 1.00.00 98/01/23
 */
public class NdsIdentityScope extends XplatIdentityScope
{
	final static boolean DEBUG = false;

   /**
    * The administrative domain name.
    */
   public static String ADMINISTRATIVE_DOMAIN_NAME = "[NDS]";

   /**
    * Container of identities in this scope.
    */
   Vector identities = new Vector();

   /**
	 * Construct the root-most identity scope with the
	 * ADMINISTRATIVE_DOMAIN_NAME name.
	 */
	public NdsIdentityScope()
	{
		this(ADMINISTRATIVE_DOMAIN_NAME);
	}

   /**
	 * Construct an identity scope with the specified String name and
	 * no scope.
	 *
	 * @param name The name of the identity.
	 */
   public NdsIdentityScope(String name)
   {
      super(name);
   }

   /**
	 * Construct an identity scope with the specified name and scope.
	 *
	 * @param name  The name of the identity scope.
	 * @param scope The scope of the identity scope.
	 *
	 * @exception com.novell.java.security.KeyManagementException
	 * Thrown when an IdentityScope cannot be constructed due to
	 * key management issues.
	 */
   public NdsIdentityScope(String name, IdentityScope scope)
      throws KeyManagementException
   {
      super(name,scope);
   }

   /**
	 * Construct an identity scope from a scope.
	 *
	 * @param scope The scope from which to copy.
	 *
	 * @exception com.novell.java.security.KeyManagementException
	 * Thrown when an IdentityScope cannot be constructed due to
	 * key management issues.
	 */
	public NdsIdentityScope(IdentityScope scope)
		throws KeyManagementException
	{
		this(scope.getName(),scope.getScope());
	}
}
