/* **************************************************************************

  %name: NativeCodeChannelProxy.java %
  %version: 20.1.1 %
  %date_modified: Sat Feb 21 23:41:54 1998 %

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.security.channels;

import java.io.*;
import java.net.*;
import java.util.*;

import com.novell.java.security.*;
import com.novell.java.util.Debug;

/**
 * @author  Jan Sture Nielsen
 *
 * @see com.novell.java.security.Authenticator
 * @see com.novell.java.security.AuthenticatorChannel
 * @see com.novell.java.security.AuthenticatorProtocol
 */
public class NativeCodeChannelProxy implements AuthenticatorChannel
{
   static final boolean DEBUG = false;
   
	/**
    * protocols to use on the channel
    */
   protected AuthenticatorProtocol protocols[];

   /**
    * constructor
    */
   public NativeCodeChannelProxy()
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy() ");
   }

   /**
    * configure the channel
    */
   public void configure(java.util.Properties properties, String baseKey)
   {
   }

   /**
    * initialize the protocols which the channel should use
    */
   public void init(AuthenticatorProtocol protocols[])
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.init("+protocols+")");

      this.protocols = protocols;

      for(int i=0; i<this.protocols.length; i++)
         this.protocols[i].init(this);
   }

   public AuthenticatorProtocol[] getProtocols()
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.getProtocols()");

      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.getProtocols() returning "+protocols.length+" protocol(s):"+protocols);

      return protocols;
   }

   /**
    * indicate the beginning of the authentication protocol
    *
    * @param protocol authentication protocol being started
    */
   public void beginProtocol(AuthenticatorProtocol protocol)
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.beginProtocol("+protocol+")");
   }

   /**
    * startup the <code>AuthenticationChannel</code>, if necessary.
    */
   void open()
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.open() ");
   }

   /**
    * write to the <code>AuthenticatorChannel</code> and wait for a response
    *
    * @param write write buffer being sent
    * @param read buffer being filled by the response up to read.length bytes
    *
    * @return int number of bytes read
    */
   public int writeRead(byte write[], byte read[])
   {
      return writeRead(write,read,0,read.length);
   }

   /**
    * write to the <code>AuthenticatorChannel</code> and wait for a response
    *
    * @param write write buffer being sent
    * @param read read buffer being filled by the response
    * @param offset fill stating-point in the read buffer
    * @param length number of bytes to read into the read buffer
    *
    * @return int number of bytes read
    */
   public int writeRead(byte write[], byte read[], int offset, int length)
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.writeRead(...) ");

      return 0;
   }

   /**
    * write to the <code>AuthenticatorChannel</code> and wait for a response
    *
    * @param write write buffer being sent
    * @param read read buffer being filled by the response
    * @param offset fill stating-point in the read buffer
    * @param length number of bytes to read into the read buffer
    *
    * @return int number of bytes read
    */
   public void write(byte write[])
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.write(...) ");
   }
   /**
    * read the <code>AuthenticatorChannel</code> and fill read buffer with the result
    *
    * @param read buffer being filled by the response up to read.length bytes
    *
    * @return int number of bytes read
    */
   public int read(byte read[])
   {
      return read(read,0,read.length);
   }

   /**
    * read the <code>AuthenticatorChannel</code> and fill read buffer with the result
    *
    * @param read buffer being filled by the response
    * @param offset stating point in the read buffer to fill
    * @param length length of the read possible
    *
    * @return int number of bytes read
    */
   public int read(byte read[], int offset, int length)
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.read(...) ");

      return 0;
   }

   /**
    * indicate the end of the Authenticator protocol
    * 
    * @param protocol completed authentication protocol
    */
   public void endProtocol(AuthenticatorProtocol protocol)
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.endProtocol("+protocol+")");
   }

   /**
    * shutdown the <code>AuthenticatorChannel</code>
    */
   void close()
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.close() ");
   }

   /**
    * perform each of the configured authentication protocols
    */
   public void run()
   {
      if(DEBUG)
         Debug.println("NativeCodeChannelProxy.run()");
   }

   public boolean equals(Object another)
   {
      if(this == another)
         return true;

      return false;
   }
}
