/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerCountsImpl.java $
  $Revision: 9 $
  $Modtime: 1/28/00 12:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import javax.naming.*;
import javax.naming.directory.*;
import com.novell.service.jncp.*;
import com.novell.service.session.*;
import com.novell.service.session.xplat.*;
import com.novell.service.rfc1960.SearchStringComponent;

/**
* Provides the Attribute value of an attribute of a ServerDirContext.
*
* @see ServerCounts
*/
public class ServerCountsImpl implements
com.novell.utility.naming.directory.StaticAttributeValue,
com.novell.service.server.ServerCounts
{
   private int numberOfNCPRequests;  // From NWGetFileServerInfo.
   private short maxConnections;     // From NWGetFileServerVersionInfo.
   private short maxConnectionsUsed; // From NWGetFileServerVersionInfo.
   private short connectionsInUse;   // From NWGetFileServerVersionInfo.
   private short maxVolumes;         // From NWGetFileServerVersionInfo.
   private byte SFTLevel;            // From NWGetFileServerVersionInfo.
   private byte TTSLevel;            // From NWGetFileServerVersionInfo.
   private boolean empty1 = true;
   private boolean empty2 = true;
   private Session session;

   /**
   * Constructs a ServerCountsImpl attribute value. This constructor
   * is used to manually create attributes for methods such as search().
   */
   public ServerCountsImpl()
   {
   }

   /** @internal
   * Constructs this attribute value and stores the session to the server.
   * This constructor is for use by ServerDirContext
   * @param session The session to the server this attribute is for.
   */
   protected ServerCountsImpl(
         Session session)
   {
      this.session = session;
   }

  /**
   * Returns the number of the NCP requests since the server was
   * brough up.
   *
   * @return The number of NCP request.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public int getNumberOfNCPRequests() throws NSIException
   {
      if(empty1)
         getFileServerInfo();
      return numberOfNCPRequests;
   }

  /**
   * Returns the maximum number of connection slots that the server
   * has allocated since it was started. It does not indicate how
   * many connections the server supports.
   *
   * @return  The maximum number of connection slots.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getMaxConnections() throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      return maxConnections;
   }

  /**
   * Returns the maximum number of licensed connections in use at
   * one time.
   *
   * @return  The maximum number of connections.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getMaxConnectionsUsed() throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      return maxConnectionsUsed;
   }

  /**
   * Returns the number of connections currently in use.
   *
   * @return The number of connections in use.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getConnectionsInUse() throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      return connectionsInUse;
   }

  /**
   * Returns the maximum number of volumes supported.
   *
   * @return  The number of volumes supported.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getMaxVolumes() throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      return maxVolumes;
   }

  /**
   * Returns the SFT level of the server.
   *
   * @return The server's SFT level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getSFTLevel() throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      return SFTLevel;
   }

  /**
   * Returns the TTS level of the server.
   *
   * @return  The server's TTS level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getTTSLevel() throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      return TTSLevel;
   }

  /**
   * Sets the number of NCP requests as the search value. This is
   * used to search for all servers matching the value parameter.
   *
   * @param value The number of NCP request.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setNumberOfNCPRequests(
         int value)
      throws NSIException
   {
      if(empty1)
         getFileServerInfo();
      numberOfNCPRequests = value;
   }

  /**
   * Sets the maximum number of connection slots as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The maximum number of connection slots.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMaxConnections(
         short value)
      throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      maxConnections = value;
   }

  /**
   * Sets the maximum number of licensed connections in use at
   * one time as the search value. This is used to search for
   * all servers matching the value parameter.
   *
   * @param value The maximum number of connections.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMaxConnectionsUsed(
         short value)
      throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      maxConnectionsUsed = value;
   }

  /**
   * Sets the number of connections currently in use as the search
   * value. This is used to search for all servers matching the
   * value parameter.
   *
   * @param value The number of connections in use.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setConnectionsInUse(
         short value)
      throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      connectionsInUse = value;
   }

  /**
   * Sets the maximum number of volumes supported as the search
   * value. This is used to search for all servers matching the
   * value parameter.
   *
   * @param value The number of volumes supported.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMaxVolumes(
         short value)
      throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      maxVolumes = value;
   }

  /**
   * Sets the SFT level of the server as the search value. This is
   * used to search for all servers matching the value parameter.
   *
   * @param value The server's SFT level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setSFTLevel(
         byte value)
      throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      SFTLevel = value;
   }

  /**
   * Sets the TTS level of the server as the search value. This is
   * used to search for all servers matching the value parameter.
   *
   * @param value The server's TTS level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setTTSLevel(
         byte value)
      throws NSIException
   {
      if(empty2)
         getFileServerVersionInfo();
      TTSLevel = value;
   }

   /**
   * Get service from the session and fill in the instance values
   */
   private void getFileServerInfo() throws NSIException
   {
      empty1 = false;
      //only call if valid session. This allows users to new()
      // instances of this class for search()
      if(session == null)
         return;
      CNWFSEFileServerInfo info = new CNWFSEFileServerInfo();
      try
      {
         ((CallsService)session.getService(
            CallsService.KEY)).getFileServerInfo(info);
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }

      numberOfNCPRequests  = info.numOfNCPRequests;
   }

   /*
   * Get service from the session and fill in the instance values
   */
   private void getFileServerVersionInfo() throws NSIException
   {
      empty2 = false;
      //only call native if valid session. This allows users to new()
      // instances of this class for search()
      if(session == null)
         return;
      CVersionInfo info = new CVersionInfo();
      try
      {
         ((CallsService)session.getService(
            CallsService.KEY)).getFileServerVersionInfo(info);
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }

      maxConnections = (short)info.iMaximumConnections;
      maxConnectionsUsed = (short)info.iMaxConnectionsEverUsed;
      connectionsInUse = (short)info.iConnectionsInUse;
      maxVolumes = (short)info.iMaxVolumes;
      SFTLevel = (byte)info.iSFTLevel;
      TTSLevel = (byte)info.iTTSLevel;
   }

   /** @internal
   */   
   public Attribute buildAttribute() throws NamingException
   {
      return new BasicAttribute(ATTR_ID, this);
   }

   /** @internal
   */   
   public String getID()
   {
      return ATTR_ID;
   }

   /** @internal
   */   
   public boolean compare(
         SearchStringComponent ssc)
      throws NamingException
   {
      int opType = ssc.getOperationType();
      if(opType == SearchStringComponent.PRESENT)
         return true;
      if(opType == SearchStringComponent.EQUALS)
         return equals(ssc.getReplacementObject());
      return false;
   }

   /** @internal
   */   
   public boolean equals(
         Object compObject)
   {
      if(compObject== null || !(compObject instanceof ServerCountsImpl) )
         return false;
      ServerCountsImpl obj = (ServerCountsImpl)compObject;
      if(obj == this)
         return true;
      try
      {
         if(empty1)
            getFileServerInfo();
         if(empty2)
            getFileServerVersionInfo();
         if(numberOfNCPRequests == obj.getNumberOfNCPRequests() &&
            maxConnections == obj.getMaxConnections() &&
            maxConnectionsUsed == obj.getMaxConnectionsUsed() &&
            connectionsInUse == obj.getConnectionsInUse() &&
            maxVolumes == obj.getMaxVolumes() &&
            SFTLevel == obj.getSFTLevel() &&
            TTSLevel == obj.getTTSLevel() )
         {
            return true;
         }
         return false;
      }
      catch(NSIException e)
      {
         return false;
      }
   }

   // Server does not support modifying attributes
   // so all of the following methods are not supported.
   /** @internal
   */   
   public void addAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void deleteAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void modifyAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public boolean hasMoreElements()
   {
      return false;
   }

   /** @internal
   */   
   public Object nextElement()
   {
      throw new java.util.NoSuchElementException();
   }

   /** @internal
   */   
   public Object getStaticInterface()
   {
      return this;
   }
}
