/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerDescription.java $
  $Revision: 9 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import com.novell.service.jncp.NSIException;

/**
 * Provides a specific attribute of a ServerDirContext. The ID of the
 * attribute is equal to ATTR_ID, and the value of this attribute is
 * an object that implements this interface.
 */
public interface ServerDescription
{
   /**
   *  The attribute ID of the ServerDescription attribute.
   *
   *  <p>(ATTR_ID = "ServerDescription")
   */
   public final static String ATTR_ID = "ServerDescription";

   /**
   *  @deprecated
   *  This member will be removed. Use ATTR_ID instead.
   */
   public final static String attrID = ATTR_ID;

   /**
    * Returns the name of the company providing the version of
    * NetWare.
    * 
    * @return The name of the company providing the version of
    *         the NetWare OS.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public String getCompanyName() throws NSIException;

   /**
    * Returns the server's version and revision description string.
    *
    * @return The server's version and revision description string.
    *
    * @exception NSIException When an error occurs retrieving the 
    *                         information.
    */
   public String getRevision() throws NSIException;

   /**
    * Returns the revision date of the server.
    *
    * @return The server's revision date in the form of mm/dd/yyyy.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */

   public String getRevisionDate() throws NSIException;

   /**
    * Returns the copyright notice of the server.
    *
    * @return The server's copyright notice.
    *
    * @exception NSIException When an error occurs retrieving the 
    *                         information.
    */
   public String getCopyrightNotice() throws NSIException;

   /**
    * Sets the name of the company providing the version of the
    * NetWare OS as the search value. This is used to search for
    * all servers matching the value parameter.
    * 
    * @param value The name of the company providing the version of
    *              NetWare.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setCompanyName(
         String value)
      throws NSIException;
      
   /**
    * Sets the version of the server and revision description string
    * as the search value. This is used to search for all servers
    * matching the value parameter.
    * 
    * @param value The server's version and revision description string.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setRevision(
         String value)
      throws NSIException;
      
   /**
    * Sets the server's revision date in the form of mm/dd/yyyy
    * as the search value. This is used to search for all servers
    * matching the value parameter.
    * 
    * @param value the revision date of the server.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setRevisionDate(
         String value)
      throws NSIException;
      
   /**
    * Sets the copyright notice of the server as the search value.
    * This is used to search for all servers matching the value
    * parameter.
    * 
    * @param value The server's copyright notice.
    *
    * @exception NSIException  When an error occurs retrieving the 
    *                          information.
    */
   public void setCopyrightNotice(
         String value)
      throws NSIException;
}
