/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/Authenticatable.java $
  $Revision: 14 $
  $Modtime: 1/24/00 7:59p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.*;
import com.novell.java.security.*;

/**
 * Provides an interface for all objects returned by the SessionManager
 * that can be authenticated. All such objects are of type Authenticatable.
 */
public interface Authenticatable
{
   /**
    * Attribute id describing the state of a Session. The associated value is
    * a Boolean.
    *
    * <p>(IS_AUTHENTICATED_ATTR_ID = "IS_AUTHENTICATED_STATE")</p>
    *
    * @see  SessionAttr
    * @see  Session#getAttributes
    */
   public static final String IS_AUTHENTICATED_ATTR_ID =
      "IS_AUTHENTICATED_STATE";

   /**
    * Attribute id describing the user name of an Authenticatable Session.
    * The associated value is a String.
    *
    * <p>(USER_NAME_ATTR_ID = "USER_NAME")</p>
    *
    * @see  SessionAttr
    * @see  Session#getAttributes
    */
   public static final String USER_NAME_ATTR_ID = "USER_NAME";

   /**
    * @deprecated Use com.novell.java.security and related packages.
    *
    * Returns the name used to authenticate this object, or null if not
    * authenticated.
    *
    * @exception SessionException Or a subclass thereof.
    *
    * @see com.novell.java.security.Authenticator#getIdentities
    */
   public String getName
   (
   )
   throws SessionException;

   /**
    * @deprecated Use com.novell.java.security and related packages.
    *
    * Authenticate the object by name.
    *
    * @exception SessionException Or a subclass thereof.
    *
    * @see com.novell.java.security.Authenticator#login
    */
   public void authenticate
   (
      String name
   )
   throws SessionException;

   /**
    * @deprecated Use com.novell.java.security and related packages.
    *
    * Authenticate the object by using it's parent's credentials, if any.
    *
    * @exception SessionException Or a subclass thereof.
    *
    * @see com.novell.java.security.Authenticator#login
    */
   public void authenticate
   (
   )
   throws SessionException;

   /**
    * @deprecated Use com.novell.java.security and related packages.
    *
    * Unauthenticate the object.
    *
    * @exception SessionException Or a subclass thereof.
    *
    * @see com.novell.java.security.Authenticator#logout
    */
   public void unauthenticate
   (
   )
   throws SessionException;

   /**
    * Returns TRUE if the object is authenticated.
    *
    * @return A boolean set to TRUE if the object is authenticated,
    *         otherwise set to FALSE.
    *
    * @exception SessionException Thrown by Session objects. A subclass
    *            of of SessionException might be thrown instead.
    */
   public boolean isAuthenticated
   (
   )
   throws SessionException;

   /**
    * Creates and returns an Identity based on this Session.
    *
    * @return Identity The identity based on this Session.
    *
    * @see com.novell.java.security#Identity
    *
    * @exception SessionException Thrown by Session objects. A subclass
    *            of of SessionException might be thrown instead.
    */
   public Identity createIdentity
   (
      String userName
   )
   throws SessionException;
}

